/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.hc.core5.http.ConnectionClosedException;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpMessage;
import org.apache.hc.core5.http.MessageConstraintException;
import org.apache.hc.core5.http.config.Http1Config;
import org.apache.hc.core5.http.io.HttpMessageParser;
import org.apache.hc.core5.http.io.SessionInputBuffer;
import org.apache.hc.core5.http.message.LazyLineParser;
import org.apache.hc.core5.http.message.LineParser;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.CharArrayBuffer;

public abstract class AbstractMessageParser<T extends HttpMessage>
implements HttpMessageParser<T> {
    private static final int HEAD_LINE = 0;
    private static final int HEADERS = 1;
    private final Http1Config http1Config;
    private final List<CharArrayBuffer> headerLines;
    private final CharArrayBuffer headLine;
    private final LineParser lineParser;
    private int state;
    private T message;

    public AbstractMessageParser(Http1Config http1Config, LineParser lineParser) {
        this.http1Config = http1Config != null ? http1Config : Http1Config.DEFAULT;
        this.lineParser = lineParser != null ? lineParser : LazyLineParser.INSTANCE;
        this.headerLines = new ArrayList<CharArrayBuffer>();
        this.headLine = new CharArrayBuffer(128);
        this.state = 0;
    }

    @Deprecated
    public AbstractMessageParser(LineParser lineParser, Http1Config http1Config) {
        this(http1Config, lineParser);
    }

    LineParser getLineParser() {
        return this.lineParser;
    }

    public static Header[] parseHeaders(SessionInputBuffer sessionInputBuffer, InputStream inputStream, int n2, int n3, LineParser lineParser) throws HttpException, IOException {
        ArrayList<CharArrayBuffer> arrayList = new ArrayList<CharArrayBuffer>();
        return AbstractMessageParser.parseHeaders(sessionInputBuffer, inputStream, n2, n3, lineParser != null ? lineParser : LazyLineParser.INSTANCE, arrayList);
    }

    public static Header[] parseHeaders(SessionInputBuffer sessionInputBuffer, InputStream inputStream, int n2, int n3, LineParser lineParser, List<CharArrayBuffer> list) throws HttpException, IOException {
        int n4;
        block7: {
            Args.notNull(sessionInputBuffer, "Session input buffer");
            Args.notNull(inputStream, "Input stream");
            Args.notNull(lineParser, "Line parser");
            Args.notNull(list, "Header line list");
            CharArrayBuffer charArrayBuffer = null;
            CharArrayBuffer charArrayBuffer2 = null;
            do {
                if (charArrayBuffer == null) {
                    charArrayBuffer = new CharArrayBuffer(64);
                } else {
                    charArrayBuffer.clear();
                }
                int n5 = sessionInputBuffer.readLine(charArrayBuffer, inputStream);
                if (n5 == -1 || charArrayBuffer.length() <= 0) break block7;
                if ((charArrayBuffer.charAt(0) == ' ' || charArrayBuffer.charAt(0) == '\t') && charArrayBuffer2 != null) {
                    char c2;
                    for (n4 = 0; n4 < charArrayBuffer.length() && ((c2 = charArrayBuffer.charAt(n4)) == ' ' || c2 == '\t'); ++n4) {
                    }
                    if (n3 > 0 && charArrayBuffer2.length() + 1 + charArrayBuffer.length() - n4 > n3) {
                        throw new MessageConstraintException("Maximum line length limit exceeded");
                    }
                    charArrayBuffer2.append(' ');
                    charArrayBuffer2.append(charArrayBuffer, n4, charArrayBuffer.length() - n4);
                    continue;
                }
                list.add(charArrayBuffer);
                charArrayBuffer2 = charArrayBuffer;
                charArrayBuffer = null;
            } while (n2 <= 0 || list.size() < n2);
            throw new MessageConstraintException("Maximum header count exceeded");
        }
        Header[] headerArray = new Header[list.size()];
        for (n4 = 0; n4 < list.size(); ++n4) {
            CharArrayBuffer charArrayBuffer = list.get(n4);
            headerArray[n4] = lineParser.parseHeader(charArrayBuffer);
        }
        return headerArray;
    }

    protected abstract T createMessage(CharArrayBuffer var1) throws IOException, HttpException;

    @Deprecated
    protected IOException createConnectionClosedException() {
        return new ConnectionClosedException();
    }

    @Override
    public T parse(SessionInputBuffer sessionInputBuffer, InputStream inputStream) throws IOException, HttpException {
        Args.notNull(sessionInputBuffer, "Session input buffer");
        Args.notNull(inputStream, "Input stream");
        int n2 = this.state;
        switch (n2) {
            case 0: {
                for (n2 = 0; n2 < this.http1Config.getMaxEmptyLineCount(); ++n2) {
                    this.headLine.clear();
                    int n3 = sessionInputBuffer.readLine(this.headLine, inputStream);
                    if (n3 == -1) {
                        return null;
                    }
                    if (this.headLine.length() <= 0) continue;
                    this.message = this.createMessage(this.headLine);
                    if (this.message != null) break;
                }
                if (this.message == null) {
                    throw new MessageConstraintException("Maximum empty line limit exceeded");
                }
                this.state = 1;
            }
            case 1: {
                Header[] headerArray = AbstractMessageParser.parseHeaders(sessionInputBuffer, inputStream, this.http1Config.getMaxHeaderCount(), this.http1Config.getMaxLineLength(), this.lineParser, this.headerLines);
                this.message.setHeaders(headerArray);
                T t2 = this.message;
                this.message = null;
                this.headerLines.clear();
                this.state = 0;
                return t2;
            }
        }
        throw new IllegalStateException("Inconsistent parser state");
    }
}

