/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.io;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.hc.core5.http.FormattedHeader;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpMessage;
import org.apache.hc.core5.http.io.HttpMessageWriter;
import org.apache.hc.core5.http.io.SessionOutputBuffer;
import org.apache.hc.core5.http.message.BasicLineFormatter;
import org.apache.hc.core5.http.message.LineFormatter;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.CharArrayBuffer;

public abstract class AbstractMessageWriter<T extends HttpMessage>
implements HttpMessageWriter<T> {
    private final CharArrayBuffer lineBuf;
    private final LineFormatter lineFormatter;

    public AbstractMessageWriter(LineFormatter lineFormatter) {
        this.lineFormatter = lineFormatter != null ? lineFormatter : BasicLineFormatter.INSTANCE;
        this.lineBuf = new CharArrayBuffer(128);
    }

    LineFormatter getLineFormatter() {
        return this.lineFormatter;
    }

    protected abstract void writeHeadLine(T var1, CharArrayBuffer var2) throws IOException;

    @Override
    public void write(T object, SessionOutputBuffer sessionOutputBuffer, OutputStream outputStream) throws IOException, HttpException {
        Args.notNull(object, "HTTP message");
        Args.notNull(sessionOutputBuffer, "Session output buffer");
        Args.notNull(outputStream, "Output stream");
        this.writeHeadLine(object, this.lineBuf);
        sessionOutputBuffer.writeLine(this.lineBuf, outputStream);
        object = object.headerIterator();
        while (object.hasNext()) {
            Object object2 = (Header)object.next();
            if (object2 instanceof FormattedHeader) {
                object2 = ((FormattedHeader)object2).getBuffer();
                sessionOutputBuffer.writeLine((CharArrayBuffer)object2, outputStream);
                continue;
            }
            this.lineBuf.clear();
            this.lineFormatter.formatHeader(this.lineBuf, (Header)object2);
            sessionOutputBuffer.writeLine(this.lineBuf, outputStream);
        }
        this.lineBuf.clear();
        sessionOutputBuffer.writeLine(this.lineBuf, outputStream);
    }
}

