/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.io;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.apache.hc.core5.function.Supplier;
import org.apache.hc.core5.http.ConnectionClosedException;
import org.apache.hc.core5.http.EndpointDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpMessage;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.config.Http1Config;
import org.apache.hc.core5.http.impl.BasicEndpointDetails;
import org.apache.hc.core5.http.impl.BasicHttpConnectionMetrics;
import org.apache.hc.core5.http.impl.BasicHttpTransportMetrics;
import org.apache.hc.core5.http.impl.io.ChunkedInputStream;
import org.apache.hc.core5.http.impl.io.ChunkedOutputStream;
import org.apache.hc.core5.http.impl.io.ContentLengthInputStream;
import org.apache.hc.core5.http.impl.io.ContentLengthOutputStream;
import org.apache.hc.core5.http.impl.io.IdentityInputStream;
import org.apache.hc.core5.http.impl.io.IdentityOutputStream;
import org.apache.hc.core5.http.impl.io.IncomingHttpEntity;
import org.apache.hc.core5.http.impl.io.SessionInputBufferImpl;
import org.apache.hc.core5.http.impl.io.SessionOutputBufferImpl;
import org.apache.hc.core5.http.impl.io.SocketHolder;
import org.apache.hc.core5.http.io.BHttpConnection;
import org.apache.hc.core5.http.io.HttpTransportMetrics;
import org.apache.hc.core5.http.io.SessionInputBuffer;
import org.apache.hc.core5.http.io.SessionOutputBuffer;
import org.apache.hc.core5.http.io.entity.EmptyInputStream;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.io.Closer;
import org.apache.hc.core5.net.InetAddressUtils;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.Timeout;

class BHttpConnectionBase
implements BHttpConnection {
    private static final Timeout STALE_CHECK_TIMEOUT = Timeout.ofMilliseconds(1L);
    final Http1Config http1Config;
    final SessionInputBufferImpl inBuffer;
    final SessionOutputBufferImpl outbuffer;
    final BasicHttpConnectionMetrics connMetrics;
    final AtomicReference<SocketHolder> socketHolderRef;
    private byte[] chunkedRequestBuffer;
    volatile ProtocolVersion version;
    volatile EndpointDetails endpointDetails;

    BHttpConnectionBase(Http1Config object, CharsetDecoder charsetDecoder, CharsetEncoder charsetEncoder) {
        this.http1Config = object != null ? object : Http1Config.DEFAULT;
        object = new BasicHttpTransportMetrics();
        BasicHttpTransportMetrics basicHttpTransportMetrics = new BasicHttpTransportMetrics();
        this.inBuffer = new SessionInputBufferImpl((BasicHttpTransportMetrics)object, this.http1Config.getBufferSize(), -1, this.http1Config.getMaxLineLength(), charsetDecoder);
        this.outbuffer = new SessionOutputBufferImpl(basicHttpTransportMetrics, this.http1Config.getBufferSize(), this.http1Config.getChunkSizeHint(), charsetEncoder);
        this.connMetrics = new BasicHttpConnectionMetrics((HttpTransportMetrics)object, basicHttpTransportMetrics);
        this.socketHolderRef = new AtomicReference();
    }

    protected SocketHolder ensureOpen() throws IOException {
        SocketHolder socketHolder = this.socketHolderRef.get();
        if (socketHolder == null) {
            throw new ConnectionClosedException();
        }
        return socketHolder;
    }

    protected void bind(Socket socket) throws IOException {
        Args.notNull(socket, "Socket");
        this.bind(new SocketHolder(socket));
    }

    protected void bind(SocketHolder socketHolder) throws IOException {
        Args.notNull(socketHolder, "Socket holder");
        this.socketHolderRef.set(socketHolder);
        this.endpointDetails = null;
    }

    @Override
    public boolean isOpen() {
        return this.socketHolderRef.get() != null;
    }

    @Override
    public ProtocolVersion getProtocolVersion() {
        return this.version;
    }

    protected SocketHolder getSocketHolder() {
        return this.socketHolderRef.get();
    }

    protected OutputStream createContentOutputStream(long l2, SessionOutputBuffer sessionOutputBuffer, OutputStream outputStream, Supplier<List<? extends Header>> supplier) {
        if (l2 >= 0L) {
            return new ContentLengthOutputStream(sessionOutputBuffer, outputStream, l2);
        }
        if (l2 == -1L) {
            return new ChunkedOutputStream(sessionOutputBuffer, outputStream, this.getChunkedRequestBuffer(), supplier);
        }
        return new IdentityOutputStream(sessionOutputBuffer, outputStream);
    }

    private byte[] getChunkedRequestBuffer() {
        if (this.chunkedRequestBuffer == null) {
            int n2 = this.http1Config.getChunkSizeHint();
            this.chunkedRequestBuffer = new byte[n2 > 0 ? n2 : 8192];
        }
        return this.chunkedRequestBuffer;
    }

    protected InputStream createContentInputStream(long l2, SessionInputBuffer sessionInputBuffer, InputStream inputStream) {
        if (l2 > 0L) {
            return new ContentLengthInputStream(sessionInputBuffer, inputStream, l2);
        }
        if (l2 == 0L) {
            return EmptyInputStream.INSTANCE;
        }
        if (l2 == -1L) {
            return new ChunkedInputStream(sessionInputBuffer, inputStream, this.http1Config);
        }
        return new IdentityInputStream(sessionInputBuffer, inputStream);
    }

    HttpEntity createIncomingEntity(HttpMessage httpMessage, SessionInputBuffer sessionInputBuffer, InputStream inputStream, long l2) {
        return new IncomingHttpEntity(this.createContentInputStream(l2, sessionInputBuffer, inputStream), l2 >= 0L ? l2 : -1L, l2 == -1L, httpMessage.getFirstHeader("Content-Type"), httpMessage.getFirstHeader("Content-Encoding"));
    }

    @Override
    public SocketAddress getRemoteAddress() {
        SocketHolder socketHolder = this.socketHolderRef.get();
        if (socketHolder != null) {
            return socketHolder.getSocket().getRemoteSocketAddress();
        }
        return null;
    }

    @Override
    public SocketAddress getLocalAddress() {
        SocketHolder socketHolder = this.socketHolderRef.get();
        if (socketHolder != null) {
            return socketHolder.getSocket().getLocalSocketAddress();
        }
        return null;
    }

    @Override
    public void setSocketTimeout(Timeout timeout) {
        SocketHolder socketHolder = this.socketHolderRef.get();
        if (socketHolder != null) {
            try {
                socketHolder.getSocket().setSoTimeout(Timeout.defaultsToInfinite(timeout).toMillisecondsIntBound());
                return;
            }
            catch (SocketException socketException) {}
        }
    }

    @Override
    public Timeout getSocketTimeout() {
        SocketHolder socketHolder = this.socketHolderRef.get();
        if (socketHolder != null) {
            try {
                return Timeout.ofMilliseconds(socketHolder.getSocket().getSoTimeout());
            }
            catch (SocketException socketException) {}
        }
        return Timeout.INFINITE;
    }

    @Override
    public void close(CloseMode closeMode) {
        Object object = this.socketHolderRef.getAndSet(null);
        if (object != null) {
            SSLSocket sSLSocket = ((SocketHolder)object).getSSLSocket();
            object = ((SocketHolder)object).getBaseSocket();
            if (closeMode == CloseMode.IMMEDIATE) {
                try {
                    ((Socket)object).setSoLinger(true, 0);
                }
                catch (IOException iOException) {
                }
                finally {
                    Closer.closeQuietly((Closeable)object);
                }
            } else {
                try {
                    if (sSLSocket != null) {
                        try {
                            try {
                                if (!sSLSocket.isOutputShutdown()) {
                                    sSLSocket.shutdownOutput();
                                }
                                if (!sSLSocket.isInputShutdown()) {
                                    sSLSocket.shutdownInput();
                                }
                            }
                            catch (UnsupportedOperationException unsupportedOperationException) {}
                            sSLSocket.close();
                        }
                        catch (IOException iOException) {}
                    }
                    return;
                }
                finally {
                    Closer.closeQuietly((Closeable)object);
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void close() throws IOException {
        Object object = this.socketHolderRef.getAndSet(null);
        if (object == null) return;
        Socket socket = ((SocketHolder)object).getBaseSocket();
        Throwable throwable = null;
        try {
            this.inBuffer.clear();
            this.outbuffer.flush(((SocketHolder)object).getOutputStream());
            object = ((SocketHolder)object).getSSLSocket();
            if (object != null) {
                ((Socket)object).close();
            }
            if (socket == null) return;
        }
        catch (Throwable throwable2) {
            try {
                object = throwable2;
                throwable = throwable2;
                throw object;
            }
            catch (Throwable throwable3) {
                if (socket == null) throw throwable3;
                if (throwable != null) {
                    try {
                        socket.close();
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable3;
                } else {
                    socket.close();
                }
                throw throwable3;
            }
        }
        socket.close();
        return;
    }

    private int fillInputBuffer(Timeout timeout) throws IOException {
        SocketHolder socketHolder = this.ensureOpen();
        Socket socket = socketHolder.getSocket();
        int n2 = socket.getSoTimeout();
        try {
            socket.setSoTimeout(timeout.toMillisecondsIntBound());
            int n3 = this.inBuffer.fillBuffer(socketHolder.getInputStream());
            return n3;
        }
        finally {
            socket.setSoTimeout(n2);
        }
    }

    protected boolean awaitInput(Timeout timeout) throws IOException {
        if (this.inBuffer.hasBufferedData()) {
            return true;
        }
        this.fillInputBuffer(timeout);
        return this.inBuffer.hasBufferedData();
    }

    @Override
    public boolean isDataAvailable(Timeout timeout) throws IOException {
        this.ensureOpen();
        try {
            return this.awaitInput(timeout);
        }
        catch (SocketTimeoutException socketTimeoutException) {
            return false;
        }
    }

    @Override
    public boolean isStale() throws IOException {
        if (!this.isOpen()) {
            return true;
        }
        try {
            int n2 = this.fillInputBuffer(STALE_CHECK_TIMEOUT);
            return n2 < 0;
        }
        catch (SocketTimeoutException socketTimeoutException) {
            return false;
        }
        catch (SocketException socketException) {
            return true;
        }
    }

    @Override
    public void flush() throws IOException {
        SocketHolder socketHolder = this.ensureOpen();
        this.outbuffer.flush(socketHolder.getOutputStream());
    }

    protected void incrementRequestCount() {
        this.connMetrics.incrementRequestCount();
    }

    protected void incrementResponseCount() {
        this.connMetrics.incrementResponseCount();
    }

    @Override
    public SSLSession getSSLSession() {
        Object object = this.socketHolderRef.get();
        if (object != null) {
            if ((object = ((SocketHolder)object).getSocket()) instanceof SSLSocket) {
                return ((SSLSocket)object).getSession();
            }
            return null;
        }
        return null;
    }

    @Override
    public EndpointDetails getEndpointDetails() {
        Object object;
        if (this.endpointDetails == null && (object = this.socketHolderRef.get()) != null) {
            Timeout timeout;
            object = ((SocketHolder)object).getSocket();
            try {
                timeout = Timeout.ofMilliseconds(((Socket)object).getSoTimeout());
            }
            catch (SocketException socketException) {
                timeout = Timeout.INFINITE;
            }
            this.endpointDetails = new BasicEndpointDetails(((Socket)object).getRemoteSocketAddress(), ((Socket)object).getLocalSocketAddress(), this.connMetrics, timeout);
        }
        return this.endpointDetails;
    }

    public String toString() {
        Object object = this.socketHolderRef.get();
        if (object != null) {
            object = ((SocketHolder)object).getSocket();
            StringBuilder stringBuilder = new StringBuilder();
            SocketAddress socketAddress = ((Socket)object).getRemoteSocketAddress();
            object = ((Socket)object).getLocalSocketAddress();
            if (socketAddress != null && object != null) {
                InetAddressUtils.formatAddress(stringBuilder, (SocketAddress)object);
                stringBuilder.append("<->");
                InetAddressUtils.formatAddress(stringBuilder, socketAddress);
            }
            return stringBuilder.toString();
        }
        return "[Not bound]";
    }
}

