/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.io;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.hc.core5.function.Supplier;
import org.apache.hc.core5.http.FormattedHeader;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.StreamClosedException;
import org.apache.hc.core5.http.io.SessionOutputBuffer;
import org.apache.hc.core5.http.message.BasicLineFormatter;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.CharArrayBuffer;

public class ChunkedOutputStream
extends OutputStream {
    private final SessionOutputBuffer buffer;
    private final OutputStream outputStream;
    private final byte[] cache;
    private int cachePosition;
    private boolean wroteLastChunk;
    private boolean closed;
    private final CharArrayBuffer lineBuffer;
    private final Supplier<List<? extends Header>> trailerSupplier;

    public ChunkedOutputStream(SessionOutputBuffer sessionOutputBuffer, OutputStream outputStream, byte[] byArray, Supplier<List<? extends Header>> supplier) {
        this.buffer = Args.notNull(sessionOutputBuffer, "Session output buffer");
        this.outputStream = Args.notNull(outputStream, "Output stream");
        this.cache = Args.notNull(byArray, "Chunk cache");
        this.lineBuffer = new CharArrayBuffer(32);
        this.trailerSupplier = supplier;
    }

    public ChunkedOutputStream(SessionOutputBuffer sessionOutputBuffer, OutputStream outputStream, int n2, Supplier<List<? extends Header>> supplier) {
        this(sessionOutputBuffer, outputStream, new byte[n2 > 0 ? n2 : 8192], supplier);
    }

    public ChunkedOutputStream(SessionOutputBuffer sessionOutputBuffer, OutputStream outputStream, int n2) {
        this(sessionOutputBuffer, outputStream, n2, null);
    }

    private void flushCache() throws IOException {
        if (this.cachePosition > 0) {
            this.lineBuffer.clear();
            this.lineBuffer.append(Integer.toHexString(this.cachePosition));
            this.buffer.writeLine(this.lineBuffer, this.outputStream);
            this.buffer.write(this.cache, 0, this.cachePosition, this.outputStream);
            this.lineBuffer.clear();
            this.buffer.writeLine(this.lineBuffer, this.outputStream);
            this.cachePosition = 0;
        }
    }

    private void flushCacheWithAppend(byte[] byArray, int n2, int n3) throws IOException {
        this.lineBuffer.clear();
        this.lineBuffer.append(Integer.toHexString(this.cachePosition + n3));
        this.buffer.writeLine(this.lineBuffer, this.outputStream);
        this.buffer.write(this.cache, 0, this.cachePosition, this.outputStream);
        this.buffer.write(byArray, n2, n3, this.outputStream);
        this.lineBuffer.clear();
        this.buffer.writeLine(this.lineBuffer, this.outputStream);
        this.cachePosition = 0;
    }

    private void writeClosingChunk() throws IOException {
        this.lineBuffer.clear();
        this.lineBuffer.append('0');
        this.buffer.writeLine(this.lineBuffer, this.outputStream);
        this.writeTrailers();
        this.lineBuffer.clear();
        this.buffer.writeLine(this.lineBuffer, this.outputStream);
    }

    private void writeTrailers() throws IOException {
        List<? extends Header> list = this.trailerSupplier != null ? this.trailerSupplier.get() : null;
        if (list != null) {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                Object object = list.get(i2);
                if (object instanceof FormattedHeader) {
                    object = ((FormattedHeader)object).getBuffer();
                    this.buffer.writeLine((CharArrayBuffer)object, this.outputStream);
                    continue;
                }
                this.lineBuffer.clear();
                BasicLineFormatter.INSTANCE.formatHeader(this.lineBuffer, (Header)object);
                this.buffer.writeLine(this.lineBuffer, this.outputStream);
            }
        }
    }

    public void finish() throws IOException {
        if (!this.wroteLastChunk) {
            this.flushCache();
            this.writeClosingChunk();
            this.wroteLastChunk = true;
        }
    }

    @Override
    public void write(int n2) throws IOException {
        if (this.closed) {
            throw new StreamClosedException();
        }
        this.cache[this.cachePosition] = (byte)n2;
        ++this.cachePosition;
        if (this.cachePosition == this.cache.length) {
            this.flushCache();
        }
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) throws IOException {
        if (this.closed) {
            throw new StreamClosedException();
        }
        if (n3 >= this.cache.length - this.cachePosition) {
            this.flushCacheWithAppend(byArray, n2, n3);
            return;
        }
        System.arraycopy(byArray, n2, this.cache, this.cachePosition, n3);
        this.cachePosition += n3;
    }

    @Override
    public void flush() throws IOException {
        this.flushCache();
        this.buffer.flush(this.outputStream);
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.finish();
            this.buffer.flush(this.outputStream);
        }
    }
}

