/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.io;

import java.io.IOException;
import java.io.InputStream;
import org.apache.hc.core5.http.ConnectionClosedException;
import org.apache.hc.core5.http.StreamClosedException;
import org.apache.hc.core5.http.io.SessionInputBuffer;
import org.apache.hc.core5.util.Args;

public class ContentLengthInputStream
extends InputStream {
    private static final int BUFFER_SIZE = 2048;
    private final SessionInputBuffer buffer;
    private final InputStream inputStream;
    private final long contentLength;
    private long pos;
    private boolean closed;

    public ContentLengthInputStream(SessionInputBuffer sessionInputBuffer, InputStream inputStream, long l2) {
        this.buffer = Args.notNull(sessionInputBuffer, "Session input buffer");
        this.inputStream = Args.notNull(inputStream, "Input stream");
        this.contentLength = Args.notNegative(l2, "Content length");
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            try {
                if (this.pos < this.contentLength) {
                    byte[] byArray = new byte[2048];
                    while (this.read(byArray) >= 0) {
                    }
                }
                return;
            }
            finally {
                this.closed = true;
            }
        }
    }

    @Override
    public int available() throws IOException {
        int n2 = this.buffer.length();
        return Math.min(n2, (int)(this.contentLength - this.pos));
    }

    @Override
    public int read() throws IOException {
        if (this.closed) {
            throw new StreamClosedException();
        }
        if (this.pos >= this.contentLength) {
            return -1;
        }
        int n2 = this.buffer.read(this.inputStream);
        if (n2 == -1) {
            if (this.pos < this.contentLength) {
                throw new ConnectionClosedException("Premature end of Content-Length delimited message body (expected: %d; received: %d)", this.contentLength, this.pos);
            }
        } else {
            ++this.pos;
        }
        return n2;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        if (this.closed) {
            throw new StreamClosedException();
        }
        if (n3 == 0) {
            return 0;
        }
        if (this.pos >= this.contentLength) {
            return -1;
        }
        int n5 = n3;
        if (this.pos + (long)n3 > this.contentLength) {
            n5 = (int)(this.contentLength - this.pos);
        }
        if ((n4 = this.buffer.read(byArray, n2, n5, this.inputStream)) == -1 && this.pos < this.contentLength) {
            throw new ConnectionClosedException("Premature end of Content-Length delimited message body (expected: %d; received: %d)", this.contentLength, this.pos);
        }
        if (n4 > 0) {
            this.pos += (long)n4;
        }
        return n4;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public long skip(long l2) throws IOException {
        int n2;
        if (l2 <= 0L) {
            return 0L;
        }
        byte[] byArray = new byte[2048];
        long l3 = 0L;
        for (long i2 = Math.min(l2, this.contentLength - this.pos); i2 > 0L && (n2 = this.read(byArray, 0, (int)Math.min(2048L, i2))) != -1; i2 -= (long)n2) {
            l3 += (long)n2;
        }
        return l3;
    }
}

