/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.io;

import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.Iterator;
import javax.net.ssl.SSLSocket;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentLengthStrategy;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpMessage;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.LengthRequiredException;
import org.apache.hc.core5.http.MessageHeaders;
import org.apache.hc.core5.http.NoHttpResponseException;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.UnsupportedHttpVersionException;
import org.apache.hc.core5.http.config.Http1Config;
import org.apache.hc.core5.http.impl.DefaultContentLengthStrategy;
import org.apache.hc.core5.http.impl.io.BHttpConnectionBase;
import org.apache.hc.core5.http.impl.io.DefaultBHttpClientConnection$1;
import org.apache.hc.core5.http.impl.io.DefaultHttpRequestWriterFactory;
import org.apache.hc.core5.http.impl.io.DefaultHttpResponseParserFactory;
import org.apache.hc.core5.http.impl.io.ResponseOutOfOrderException;
import org.apache.hc.core5.http.impl.io.SocketHolder;
import org.apache.hc.core5.http.io.HttpClientConnection;
import org.apache.hc.core5.http.io.HttpMessageParser;
import org.apache.hc.core5.http.io.HttpMessageParserFactory;
import org.apache.hc.core5.http.io.HttpMessageWriter;
import org.apache.hc.core5.http.io.HttpMessageWriterFactory;
import org.apache.hc.core5.http.io.ResponseOutOfOrderStrategy;
import org.apache.hc.core5.http.message.MessageSupport;
import org.apache.hc.core5.util.Args;

public class DefaultBHttpClientConnection
extends BHttpConnectionBase
implements HttpClientConnection {
    private final HttpMessageParser<ClassicHttpResponse> responseParser;
    private final HttpMessageWriter<ClassicHttpRequest> requestWriter;
    private final ContentLengthStrategy incomingContentStrategy;
    private final ContentLengthStrategy outgoingContentStrategy;
    private final ResponseOutOfOrderStrategy responseOutOfOrderStrategy;
    private volatile boolean consistent;

    public DefaultBHttpClientConnection(Http1Config http1Config, CharsetDecoder charsetDecoder, CharsetEncoder charsetEncoder, ContentLengthStrategy contentLengthStrategy, ContentLengthStrategy contentLengthStrategy2, ResponseOutOfOrderStrategy responseOutOfOrderStrategy, HttpMessageWriterFactory<ClassicHttpRequest> defaultHttpRequestWriterFactory, HttpMessageParserFactory<ClassicHttpResponse> defaultHttpResponseParserFactory) {
        super(http1Config, charsetDecoder, charsetEncoder);
        this.requestWriter = (defaultHttpRequestWriterFactory != null ? defaultHttpRequestWriterFactory : DefaultHttpRequestWriterFactory.INSTANCE).create();
        this.responseParser = (defaultHttpResponseParserFactory != null ? defaultHttpResponseParserFactory : DefaultHttpResponseParserFactory.INSTANCE).create();
        this.incomingContentStrategy = contentLengthStrategy != null ? contentLengthStrategy : DefaultContentLengthStrategy.INSTANCE;
        this.outgoingContentStrategy = contentLengthStrategy2 != null ? contentLengthStrategy2 : DefaultContentLengthStrategy.INSTANCE;
        this.responseOutOfOrderStrategy = responseOutOfOrderStrategy;
        this.consistent = true;
    }

    public DefaultBHttpClientConnection(Http1Config http1Config, CharsetDecoder charsetDecoder, CharsetEncoder charsetEncoder, ContentLengthStrategy contentLengthStrategy, ContentLengthStrategy contentLengthStrategy2, HttpMessageWriterFactory<ClassicHttpRequest> httpMessageWriterFactory, HttpMessageParserFactory<ClassicHttpResponse> httpMessageParserFactory) {
        this(http1Config, charsetDecoder, charsetEncoder, contentLengthStrategy, contentLengthStrategy2, null, httpMessageWriterFactory, httpMessageParserFactory);
    }

    public DefaultBHttpClientConnection(Http1Config http1Config, CharsetDecoder charsetDecoder, CharsetEncoder charsetEncoder) {
        this(http1Config, charsetDecoder, charsetEncoder, null, null, null, null);
    }

    public DefaultBHttpClientConnection(Http1Config http1Config) {
        this(http1Config, null, null);
    }

    protected void onResponseReceived(ClassicHttpResponse classicHttpResponse) {
    }

    protected void onRequestSubmitted(ClassicHttpRequest classicHttpRequest) {
    }

    @Override
    public void bind(Socket socket) throws IOException {
        super.bind(socket);
    }

    public void bind(SSLSocket sSLSocket, Socket socket) throws IOException {
        super.bind(new SocketHolder(sSLSocket, socket));
    }

    @Override
    public void sendRequestHeader(ClassicHttpRequest classicHttpRequest) throws HttpException, IOException {
        Args.notNull(classicHttpRequest, "HTTP request");
        SocketHolder socketHolder = this.ensureOpen();
        this.requestWriter.write(classicHttpRequest, this.outbuffer, socketHolder.getOutputStream());
        this.onRequestSubmitted(classicHttpRequest);
        this.incrementRequestCount();
    }

    @Override
    public void sendRequestEntity(ClassicHttpRequest object) throws HttpException, IOException {
        block14: {
            Args.notNull(object, "HTTP request");
            Object object2 = this.ensureOpen();
            Object object3 = object.getEntity();
            if (object3 == null) {
                return;
            }
            long l2 = this.outgoingContentStrategy.determineLength((HttpMessage)object);
            if (l2 == -9223372036854775807L) {
                throw new LengthRequiredException();
            }
            try {
                block15: {
                    block13: {
                        object = this.createContentOutputStream(l2, this.outbuffer, new DefaultBHttpClientConnection$1(this, (SocketHolder)object2, (ClassicHttpRequest)object), object3.getTrailers());
                        object2 = null;
                        try {
                            object3.writeTo((OutputStream)object);
                            if (object == null) break block13;
                        }
                        catch (Throwable throwable) {
                            try {
                                object3 = throwable;
                                object2 = throwable;
                                throw object3;
                            }
                            catch (Throwable throwable2) {
                                if (object != null) {
                                    if (object2 != null) {
                                        try {
                                            ((OutputStream)object).close();
                                        }
                                        catch (Throwable throwable3) {
                                            ((Throwable)object2).addSuppressed(throwable3);
                                        }
                                    } else {
                                        ((OutputStream)object).close();
                                    }
                                }
                                throw throwable2;
                            }
                        }
                        break block15;
                    }
                    return;
                }
                ((OutputStream)object).close();
            }
            catch (ResponseOutOfOrderException responseOutOfOrderException) {
                if (l2 <= 0L) break block14;
                this.consistent = false;
            }
        }
    }

    @Override
    public boolean isConsistent() {
        return this.consistent;
    }

    @Override
    public void terminateRequest(ClassicHttpRequest object) throws HttpException, IOException {
        block15: {
            block14: {
                block13: {
                    Args.notNull(object, "HTTP request");
                    Object object2 = this.ensureOpen();
                    Object object3 = object.getEntity();
                    if (object3 == null) {
                        return;
                    }
                    Iterator<String> iterator = MessageSupport.iterateTokens((MessageHeaders)object, "Connection");
                    while (iterator.hasNext()) {
                        String string = iterator.next();
                        if (!"close".equalsIgnoreCase(string)) continue;
                        this.consistent = false;
                        return;
                    }
                    long l2 = this.outgoingContentStrategy.determineLength((HttpMessage)object);
                    if (l2 == -1L) {
                        object = this.createContentOutputStream(l2, this.outbuffer, ((SocketHolder)object2).getOutputStream(), object3.getTrailers());
                        if (object != null) {
                            ((OutputStream)object).close();
                        }
                        return;
                    }
                    if (l2 < 0L || l2 > 1024L) break block14;
                    object = this.createContentOutputStream(l2, this.outbuffer, ((SocketHolder)object2).getOutputStream(), null);
                    object2 = null;
                    try {
                        object3.writeTo((OutputStream)object);
                        if (object == null) break block13;
                    }
                    catch (Throwable throwable) {
                        try {
                            object3 = throwable;
                            object2 = throwable;
                            throw object3;
                        }
                        catch (Throwable throwable2) {
                            if (object != null) {
                                if (object2 != null) {
                                    try {
                                        ((OutputStream)object).close();
                                    }
                                    catch (Throwable throwable3) {
                                        ((Throwable)object2).addSuppressed(throwable3);
                                    }
                                } else {
                                    ((OutputStream)object).close();
                                }
                            }
                            throw throwable2;
                        }
                    }
                    ((OutputStream)object).close();
                    break block15;
                }
                return;
            }
            this.consistent = false;
        }
    }

    @Override
    public ClassicHttpResponse receiveResponseHeader() throws HttpException, IOException {
        Object object = this.ensureOpen();
        if ((object = this.responseParser.parse(this.inBuffer, ((SocketHolder)object).getInputStream())) == null) {
            throw new NoHttpResponseException("The target server failed to respond");
        }
        ProtocolVersion protocolVersion = object.getVersion();
        if (protocolVersion != null && protocolVersion.greaterEquals(HttpVersion.HTTP_2)) {
            throw new UnsupportedHttpVersionException(protocolVersion);
        }
        this.version = protocolVersion;
        this.onResponseReceived((ClassicHttpResponse)object);
        int n2 = object.getCode();
        if (n2 < 100) {
            throw new ProtocolException("Invalid response: " + n2);
        }
        if (object.getCode() >= 200) {
            this.incrementResponseCount();
        }
        return object;
    }

    @Override
    public void receiveResponseEntity(ClassicHttpResponse classicHttpResponse) throws HttpException, IOException {
        Args.notNull(classicHttpResponse, "HTTP response");
        SocketHolder socketHolder = this.ensureOpen();
        long l2 = this.incomingContentStrategy.determineLength(classicHttpResponse);
        classicHttpResponse.setEntity(this.createIncomingEntity(classicHttpResponse, this.inBuffer, socketHolder.getInputStream(), l2));
    }

    static /* synthetic */ ResponseOutOfOrderStrategy access$000(DefaultBHttpClientConnection defaultBHttpClientConnection) {
        return defaultBHttpClientConnection.responseOutOfOrderStrategy;
    }
}

