/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.io;

import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpRequestFactory;
import org.apache.hc.core5.http.config.Http1Config;
import org.apache.hc.core5.http.impl.io.DefaultClassicHttpRequestFactory;
import org.apache.hc.core5.http.impl.io.DefaultHttpRequestParser;
import org.apache.hc.core5.http.io.HttpMessageParser;
import org.apache.hc.core5.http.io.HttpMessageParserFactory;
import org.apache.hc.core5.http.message.LazyLineParser;
import org.apache.hc.core5.http.message.LineParser;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class DefaultHttpRequestParserFactory
implements HttpMessageParserFactory<ClassicHttpRequest> {
    public static final DefaultHttpRequestParserFactory INSTANCE = new DefaultHttpRequestParserFactory();
    private final Http1Config http1Config;
    private final LineParser lineParser;
    private final HttpRequestFactory<ClassicHttpRequest> requestFactory;

    public DefaultHttpRequestParserFactory(Http1Config http1Config, LineParser lineParser, HttpRequestFactory<ClassicHttpRequest> defaultClassicHttpRequestFactory) {
        this.http1Config = http1Config != null ? http1Config : Http1Config.DEFAULT;
        this.lineParser = lineParser != null ? lineParser : LazyLineParser.INSTANCE;
        this.requestFactory = defaultClassicHttpRequestFactory != null ? defaultClassicHttpRequestFactory : DefaultClassicHttpRequestFactory.INSTANCE;
    }

    public DefaultHttpRequestParserFactory(LineParser lineParser, HttpRequestFactory<ClassicHttpRequest> httpRequestFactory) {
        this(null, lineParser, httpRequestFactory);
    }

    public DefaultHttpRequestParserFactory(Http1Config http1Config) {
        this(http1Config, null, null);
    }

    public DefaultHttpRequestParserFactory() {
        this(null, null);
    }

    @Override
    @Deprecated
    public HttpMessageParser<ClassicHttpRequest> create(Http1Config http1Config) {
        return new DefaultHttpRequestParser(http1Config, this.lineParser, this.requestFactory);
    }

    @Override
    public HttpMessageParser<ClassicHttpRequest> create() {
        return new DefaultHttpRequestParser(this.http1Config, this.lineParser, this.requestFactory);
    }
}

