/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.io;

import java.io.IOException;
import javax.net.ssl.SSLException;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ConnectionReuseStrategy;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.UnsupportedHttpVersionException;
import org.apache.hc.core5.http.config.Http1Config;
import org.apache.hc.core5.http.impl.DefaultConnectionReuseStrategy;
import org.apache.hc.core5.http.impl.Http1StreamListener;
import org.apache.hc.core5.http.impl.io.HttpRequestExecutor$Builder;
import org.apache.hc.core5.http.io.HttpClientConnection;
import org.apache.hc.core5.http.io.HttpResponseInformationCallback;
import org.apache.hc.core5.http.message.MessageSupport;
import org.apache.hc.core5.http.message.StatusLine;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http.protocol.HttpCoreContext;
import org.apache.hc.core5.http.protocol.HttpProcessor;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.io.Closer;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.Timeout;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class HttpRequestExecutor {
    public static final Timeout DEFAULT_WAIT_FOR_CONTINUE = Timeout.ofSeconds(3L);
    private final Http1Config http1Config;
    private final ConnectionReuseStrategy connReuseStrategy;
    private final Http1StreamListener streamListener;

    public HttpRequestExecutor(Http1Config http1Config, ConnectionReuseStrategy connectionReuseStrategy, Http1StreamListener http1StreamListener) {
        this.http1Config = http1Config != null ? http1Config : Http1Config.DEFAULT;
        this.connReuseStrategy = connectionReuseStrategy != null ? connectionReuseStrategy : DefaultConnectionReuseStrategy.INSTANCE;
        this.streamListener = http1StreamListener;
    }

    @Deprecated
    public HttpRequestExecutor(Timeout timeout, ConnectionReuseStrategy connectionReuseStrategy, Http1StreamListener http1StreamListener) {
        this(Http1Config.custom().setWaitForContinueTimeout(timeout).build(), connectionReuseStrategy, http1StreamListener);
    }

    public HttpRequestExecutor(ConnectionReuseStrategy connectionReuseStrategy) {
        this(Http1Config.DEFAULT, connectionReuseStrategy, null);
    }

    public HttpRequestExecutor() {
        this(Http1Config.DEFAULT, null, null);
    }

    /*
     * Unable to fully structure code
     */
    public ClassicHttpResponse execute(ClassicHttpRequest var1_1, HttpClientConnection var2_2, HttpResponseInformationCallback var3_3, HttpContext var4_4) throws IOException, HttpException {
        Args.notNull(var1_1, "HTTP request");
        Args.notNull(var2_2, "Client connection");
        Args.notNull(var4_4, "HTTP context");
        var4_4 = HttpCoreContext.castOrCreate(var4_4);
        try {
            var4_4.setSSLSession(var2_2.getSSLSession());
            var4_4.setEndpointDetails(var2_2.getEndpointDetails());
            var2_2.sendRequestHeader(var1_1);
            if (this.streamListener != null) {
                this.streamListener.onRequestHead(var2_2, var1_1);
            }
            var5_5 = false;
            var6_8 = var1_1.getEntity();
            if (var6_8 != null && !(var5_5 = (var6_8 = var1_1.getFirstHeader("Expect")) != null && "100-continue".equalsIgnoreCase(var6_8.getValue()) != false)) {
                var2_2.sendRequestEntity(var1_1);
            }
            var2_2.flush();
            var6_8 = null;
            while (var6_8 == null) {
                block15: {
                    block18: {
                        block16: {
                            block17: {
                                if (!var5_5) break block15;
                                v0 = var7_9 = this.http1Config.getWaitForContinueTimeout() != null ? this.http1Config.getWaitForContinueTimeout() : HttpRequestExecutor.DEFAULT_WAIT_FOR_CONTINUE;
                                if (!var2_2.isDataAvailable(var7_9)) break block16;
                                var6_8 = var2_2.receiveResponseHeader();
                                if (this.streamListener != null) {
                                    this.streamListener.onResponseHead(var2_2, (HttpResponse)var6_8);
                                }
                                if ((var7_10 = var6_8.getCode()) != 100) break block17;
                                var6_8 = null;
                                ** GOTO lbl-1000
                            }
                            if (var7_10 < 200) {
                                if (var3_3 != null) {
                                    var3_3.execute((HttpResponse)var6_8, var2_2, var4_4);
                                }
                                var6_8 = null;
                                continue;
                            }
                            if (var7_10 >= 400) {
                                var2_2.terminateRequest(var1_1);
                            } else lbl-1000:
                            // 2 sources

                            {
                                var2_2.sendRequestEntity(var1_1);
                            }
                            break block18;
                        }
                        var2_2.sendRequestEntity(var1_1);
                    }
                    var2_2.flush();
                    var5_5 = false;
                    continue;
                }
                var6_8 = var2_2.receiveResponseHeader();
                if (this.streamListener != null) {
                    this.streamListener.onResponseHead(var2_2, (HttpResponse)var6_8);
                }
                if ((var7_11 = var6_8.getCode()) < 100) {
                    throw new ProtocolException("Invalid response: " + new StatusLine((HttpResponse)var6_8));
                }
                if (var7_11 >= 200) continue;
                if (var3_3 != null && var7_11 != 100) {
                    var3_3.execute((HttpResponse)var6_8, var2_2, var4_4);
                }
                var6_8 = null;
            }
            if (MessageSupport.canResponseHaveBody(var1_1.getMethod(), (HttpResponse)var6_8)) {
                var2_2.receiveResponseEntity((ClassicHttpResponse)var6_8);
            }
            return var6_8;
        }
        catch (SSLException | HttpException var5_6) {
            Closer.closeQuietly(var2_2);
            throw var5_6;
        }
        catch (IOException | RuntimeException var5_7) {
            Closer.close(var2_2, CloseMode.IMMEDIATE);
            throw var5_7;
        }
    }

    public ClassicHttpResponse execute(ClassicHttpRequest classicHttpRequest, HttpClientConnection httpClientConnection, HttpContext httpContext) throws IOException, HttpException {
        return this.execute(classicHttpRequest, httpClientConnection, null, httpContext);
    }

    public void preProcess(ClassicHttpRequest classicHttpRequest, HttpProcessor httpProcessor, HttpContext httpContext) throws HttpException, IOException {
        Args.notNull(classicHttpRequest, "HTTP request");
        Args.notNull(httpProcessor, "HTTP processor");
        Args.notNull(httpContext, "HTTP context");
        ProtocolVersion protocolVersion = classicHttpRequest.getVersion();
        if (protocolVersion != null && !protocolVersion.lessEquals(this.http1Config.getVersion())) {
            throw new UnsupportedHttpVersionException(protocolVersion);
        }
        httpContext = HttpCoreContext.cast(httpContext);
        ((HttpCoreContext)httpContext).setProtocolVersion(protocolVersion != null ? protocolVersion : this.http1Config.getVersion());
        ((HttpCoreContext)httpContext).setRequest(classicHttpRequest);
        ClassicHttpRequest classicHttpRequest2 = classicHttpRequest;
        httpProcessor.process(classicHttpRequest2, (EntityDetails)classicHttpRequest2.getEntity(), httpContext);
    }

    public void postProcess(ClassicHttpResponse classicHttpResponse, HttpProcessor httpProcessor, HttpContext httpContext) throws HttpException, IOException {
        Args.notNull(classicHttpResponse, "HTTP response");
        Args.notNull(httpProcessor, "HTTP processor");
        Args.notNull(httpContext, "HTTP context");
        httpContext = HttpCoreContext.cast(httpContext);
        ProtocolVersion protocolVersion = classicHttpResponse.getVersion();
        if (protocolVersion != null) {
            if (protocolVersion.greaterEquals(HttpVersion.HTTP_2)) {
                throw new UnsupportedHttpVersionException(protocolVersion);
            }
            ((HttpCoreContext)httpContext).setProtocolVersion(protocolVersion);
        }
        ((HttpCoreContext)httpContext).setResponse(classicHttpResponse);
        ClassicHttpResponse classicHttpResponse2 = classicHttpResponse;
        httpProcessor.process(classicHttpResponse2, (EntityDetails)classicHttpResponse2.getEntity(), httpContext);
    }

    public boolean keepAlive(ClassicHttpRequest classicHttpRequest, ClassicHttpResponse classicHttpResponse, HttpClientConnection httpClientConnection, HttpContext httpContext) throws IOException {
        boolean bl2;
        Args.notNull(httpClientConnection, "HTTP connection");
        Args.notNull(classicHttpRequest, "HTTP request");
        Args.notNull(classicHttpResponse, "HTTP response");
        Args.notNull(httpContext, "HTTP context");
        boolean bl3 = bl2 = httpClientConnection.isConsistent() && this.connReuseStrategy.keepAlive(classicHttpRequest, classicHttpResponse, httpContext);
        if (this.streamListener != null) {
            this.streamListener.onExchangeComplete(httpClientConnection, bl2);
        }
        return bl2;
    }

    public static HttpRequestExecutor$Builder builder() {
        return new HttpRequestExecutor$Builder(null);
    }
}

