/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.io;

import java.io.IOException;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ConnectionReuseStrategy;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpConnection;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequestMapper;
import org.apache.hc.core5.http.HttpResponseFactory;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.UnsupportedHttpVersionException;
import org.apache.hc.core5.http.config.Http1Config;
import org.apache.hc.core5.http.impl.DefaultConnectionReuseStrategy;
import org.apache.hc.core5.http.impl.Http1StreamListener;
import org.apache.hc.core5.http.impl.ServerSupport;
import org.apache.hc.core5.http.impl.io.HttpService$1;
import org.apache.hc.core5.http.impl.io.HttpService$Builder;
import org.apache.hc.core5.http.io.HttpRequestHandler;
import org.apache.hc.core5.http.io.HttpServerConnection;
import org.apache.hc.core5.http.io.HttpServerRequestHandler;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.io.support.BasicHttpServerExpectationDecorator;
import org.apache.hc.core5.http.io.support.BasicHttpServerRequestHandler;
import org.apache.hc.core5.http.message.BasicClassicHttpResponse;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http.protocol.HttpCoreContext;
import org.apache.hc.core5.http.protocol.HttpProcessor;
import org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class HttpService {
    private final HttpProcessor processor;
    private final Http1Config http1Config;
    private final HttpServerRequestHandler requestHandler;
    private final ConnectionReuseStrategy connReuseStrategy;
    private final Http1StreamListener streamListener;

    public HttpService(HttpProcessor httpProcessor, HttpRequestMapper<HttpRequestHandler> httpRequestMapper, ConnectionReuseStrategy connectionReuseStrategy, HttpResponseFactory<ClassicHttpResponse> httpResponseFactory, Http1StreamListener http1StreamListener) {
        this(httpProcessor, new BasicHttpServerExpectationDecorator(new BasicHttpServerRequestHandler(httpRequestMapper, httpResponseFactory)), Http1Config.DEFAULT, connectionReuseStrategy, http1StreamListener);
    }

    public HttpService(HttpProcessor httpProcessor, HttpRequestMapper<HttpRequestHandler> httpRequestMapper, ConnectionReuseStrategy connectionReuseStrategy, HttpResponseFactory<ClassicHttpResponse> httpResponseFactory) {
        this(httpProcessor, httpRequestMapper, connectionReuseStrategy, httpResponseFactory, null);
    }

    public HttpService(HttpProcessor httpProcessor, HttpServerRequestHandler httpServerRequestHandler, ConnectionReuseStrategy connectionReuseStrategy, Http1StreamListener http1StreamListener) {
        this(httpProcessor, httpServerRequestHandler, Http1Config.DEFAULT, connectionReuseStrategy, http1StreamListener);
    }

    public HttpService(HttpProcessor httpProcessor, HttpServerRequestHandler httpServerRequestHandler, Http1Config http1Config, ConnectionReuseStrategy connectionReuseStrategy, Http1StreamListener http1StreamListener) {
        this.processor = Args.notNull(httpProcessor, "HTTP processor");
        this.requestHandler = Args.notNull(httpServerRequestHandler, "Request handler");
        this.http1Config = http1Config != null ? http1Config : Http1Config.DEFAULT;
        this.connReuseStrategy = connectionReuseStrategy != null ? connectionReuseStrategy : DefaultConnectionReuseStrategy.INSTANCE;
        this.streamListener = http1StreamListener;
    }

    public HttpService(HttpProcessor httpProcessor, HttpServerRequestHandler httpServerRequestHandler) {
        this(httpProcessor, httpServerRequestHandler, Http1Config.DEFAULT, null, null);
    }

    public void handleRequest(HttpServerConnection object, HttpContext httpContext) throws IOException, HttpException {
        Serializable serializable = new AtomicBoolean();
        httpContext = HttpCoreContext.cast(httpContext);
        try {
            ClassicHttpRequest classicHttpRequest = object.receiveRequestHeader();
            if (classicHttpRequest == null) {
                object.close();
                return;
            }
            if (this.streamListener != null) {
                this.streamListener.onRequestHead((HttpConnection)object, classicHttpRequest);
            }
            object.receiveRequestEntity(classicHttpRequest);
            ProtocolVersion protocolVersion = classicHttpRequest.getVersion();
            if (protocolVersion != null && protocolVersion.greaterEquals(HttpVersion.HTTP_2)) {
                throw new UnsupportedHttpVersionException(protocolVersion);
            }
            ((HttpCoreContext)httpContext).setProtocolVersion(protocolVersion != null ? protocolVersion : this.http1Config.getVersion());
            ((HttpCoreContext)httpContext).setRequest(classicHttpRequest);
            ((HttpCoreContext)httpContext).setSSLSession(object.getSSLSession());
            ((HttpCoreContext)httpContext).setEndpointDetails(object.getEndpointDetails());
            ClassicHttpRequest classicHttpRequest2 = classicHttpRequest;
            this.processor.process(classicHttpRequest2, (EntityDetails)classicHttpRequest2.getEntity(), httpContext);
            this.requestHandler.handle(classicHttpRequest, new HttpService$1(this, (AtomicBoolean)serializable, (HttpServerConnection)object, (HttpCoreContext)httpContext, classicHttpRequest), httpContext);
            return;
        }
        catch (HttpException httpException) {
            if (((AtomicBoolean)serializable).get()) {
                throw httpException;
            }
            BasicClassicHttpResponse basicClassicHttpResponse = new BasicClassicHttpResponse(500);
            serializable = null;
            try {
                this.handleException(httpException, basicClassicHttpResponse);
                basicClassicHttpResponse.setHeader("Connection", "close");
                ((HttpCoreContext)httpContext).setResponse(basicClassicHttpResponse);
                BasicClassicHttpResponse basicClassicHttpResponse2 = basicClassicHttpResponse;
                this.processor.process(basicClassicHttpResponse2, (EntityDetails)basicClassicHttpResponse2.getEntity(), httpContext);
                object.sendResponseHeader(basicClassicHttpResponse);
                if (this.streamListener != null) {
                    this.streamListener.onResponseHead((HttpConnection)object, basicClassicHttpResponse);
                }
                object.sendResponseEntity(basicClassicHttpResponse);
                object.close();
            }
            catch (Throwable throwable) {
                try {
                    object = throwable;
                    serializable = throwable;
                    throw object;
                }
                catch (Throwable throwable2) {
                    if (serializable != null) {
                        try {
                            basicClassicHttpResponse.close();
                        }
                        catch (Throwable throwable3) {
                            ((Throwable)serializable).addSuppressed(throwable3);
                        }
                    } else {
                        basicClassicHttpResponse.close();
                    }
                    throw throwable2;
                }
            }
            basicClassicHttpResponse.close();
            return;
        }
    }

    protected void handleException(HttpException httpException, ClassicHttpResponse classicHttpResponse) {
        classicHttpResponse.setCode(this.toStatusCode(httpException));
        classicHttpResponse.setEntity(new StringEntity(ServerSupport.toErrorMessage(httpException), ContentType.TEXT_PLAIN));
    }

    protected int toStatusCode(Exception exception) {
        return ServerSupport.toStatusCode(exception);
    }

    public static HttpService$Builder builder() {
        return new HttpService$Builder(null);
    }

    static /* synthetic */ Http1StreamListener access$000(HttpService httpService) {
        return httpService.streamListener;
    }

    static /* synthetic */ Http1Config access$100(HttpService httpService) {
        return httpService.http1Config;
    }

    static /* synthetic */ HttpProcessor access$200(HttpService httpService) {
        return httpService.processor;
    }

    static /* synthetic */ ConnectionReuseStrategy access$300(HttpService httpService) {
        return httpService.connReuseStrategy;
    }
}

