/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.io;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.hc.core5.http.StreamClosedException;
import org.apache.hc.core5.http.io.SessionOutputBuffer;
import org.apache.hc.core5.util.Args;

public class IdentityOutputStream
extends OutputStream {
    private final SessionOutputBuffer buffer;
    private final OutputStream outputStream;
    private boolean closed;

    public IdentityOutputStream(SessionOutputBuffer sessionOutputBuffer, OutputStream outputStream) {
        this.buffer = Args.notNull(sessionOutputBuffer, "Session output buffer");
        this.outputStream = Args.notNull(outputStream, "Output stream");
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.buffer.flush(this.outputStream);
        }
    }

    @Override
    public void flush() throws IOException {
        this.buffer.flush(this.outputStream);
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) throws IOException {
        if (this.closed) {
            throw new StreamClosedException();
        }
        this.buffer.write(byArray, n2, n3, this.outputStream);
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(int n2) throws IOException {
        if (this.closed) {
            throw new StreamClosedException();
        }
        this.buffer.write(n2, this.outputStream);
    }
}

