/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.hc.core5.function.Supplier;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.AbstractHttpEntity;
import org.apache.hc.core5.io.Closer;

class IncomingHttpEntity
implements HttpEntity {
    private final InputStream content;
    private final long len;
    private final boolean chunked;
    private final Header contentType;
    private final Header contentEncoding;

    IncomingHttpEntity(InputStream inputStream, long l2, boolean bl2, Header header, Header header2) {
        this.content = inputStream;
        this.len = l2;
        this.chunked = bl2;
        this.contentType = header;
        this.contentEncoding = header2;
    }

    @Override
    public boolean isRepeatable() {
        return false;
    }

    @Override
    public boolean isChunked() {
        return this.chunked;
    }

    @Override
    public long getContentLength() {
        return this.len;
    }

    @Override
    public String getContentType() {
        if (this.contentType != null) {
            return this.contentType.getValue();
        }
        return null;
    }

    @Override
    public String getContentEncoding() {
        if (this.contentEncoding != null) {
            return this.contentEncoding.getValue();
        }
        return null;
    }

    @Override
    public InputStream getContent() throws IOException, IllegalStateException {
        return this.content;
    }

    @Override
    public boolean isStreaming() {
        return this.content != null;
    }

    @Override
    public void writeTo(OutputStream outputStream) throws IOException {
        AbstractHttpEntity.writeTo(this, outputStream);
    }

    @Override
    public Supplier<List<? extends Header>> getTrailers() {
        return null;
    }

    @Override
    public Set<String> getTrailerNames() {
        return Collections.emptySet();
    }

    @Override
    public void close() throws IOException {
        Closer.close(this.content);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        stringBuilder.append("Content-Type: ");
        stringBuilder.append(this.getContentType());
        stringBuilder.append(',');
        stringBuilder.append("Content-Encoding: ");
        stringBuilder.append(this.getContentEncoding());
        stringBuilder.append(',');
        long l2 = this.getContentLength();
        if (l2 >= 0L) {
            stringBuilder.append("Content-Length: ");
            stringBuilder.append(l2);
            stringBuilder.append(',');
        }
        stringBuilder.append("Chunked: ");
        stringBuilder.append(this.isChunked());
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

