/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.nio;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import javax.net.ssl.SSLSession;
import org.apache.hc.core5.http.EndpointDetails;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.impl.nio.AbstractHttp1StreamDuplexer;
import org.apache.hc.core5.http.impl.nio.HttpConnectionEventHandler;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.reactor.IOSession;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.Timeout;

class AbstractHttp1IOEventHandler
implements HttpConnectionEventHandler {
    final AbstractHttp1StreamDuplexer<?, ?> streamDuplexer;

    AbstractHttp1IOEventHandler(AbstractHttp1StreamDuplexer<?, ?> abstractHttp1StreamDuplexer) {
        this.streamDuplexer = Args.notNull(abstractHttp1StreamDuplexer, "Stream multiplexer");
    }

    @Override
    public void connected(IOSession iOSession) throws IOException {
        try {
            this.streamDuplexer.onConnect();
            return;
        }
        catch (HttpException httpException) {
            this.streamDuplexer.onException(httpException);
            return;
        }
    }

    @Override
    public void inputReady(IOSession iOSession, ByteBuffer byteBuffer) throws IOException {
        try {
            this.streamDuplexer.onInput(byteBuffer);
            return;
        }
        catch (HttpException httpException) {
            this.streamDuplexer.onException(httpException);
            return;
        }
    }

    @Override
    public void outputReady(IOSession iOSession) throws IOException {
        try {
            this.streamDuplexer.onOutput();
            return;
        }
        catch (HttpException httpException) {
            this.streamDuplexer.onException(httpException);
            return;
        }
    }

    @Override
    public void timeout(IOSession iOSession, Timeout timeout) throws IOException {
        try {
            this.streamDuplexer.onTimeout(timeout);
            return;
        }
        catch (HttpException httpException) {
            this.streamDuplexer.onException(httpException);
            return;
        }
    }

    @Override
    public void exception(IOSession iOSession, Exception exception) {
        this.streamDuplexer.onException(exception);
    }

    @Override
    public void disconnected(IOSession iOSession) {
        this.streamDuplexer.onDisconnect();
    }

    @Override
    public void close() throws IOException {
        this.streamDuplexer.close();
    }

    @Override
    public void close(CloseMode closeMode) {
        this.streamDuplexer.close(closeMode);
    }

    @Override
    public boolean isOpen() {
        return this.streamDuplexer.isOpen();
    }

    @Override
    public void setSocketTimeout(Timeout timeout) {
        this.streamDuplexer.setSocketTimeout(timeout);
    }

    @Override
    public SSLSession getSSLSession() {
        return this.streamDuplexer.getSSLSession();
    }

    @Override
    public EndpointDetails getEndpointDetails() {
        return this.streamDuplexer.getEndpointDetails();
    }

    @Override
    public Timeout getSocketTimeout() {
        return this.streamDuplexer.getSocketTimeout();
    }

    @Override
    public ProtocolVersion getProtocolVersion() {
        return this.streamDuplexer.getProtocolVersion();
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this.streamDuplexer.getRemoteAddress();
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.streamDuplexer.getLocalAddress();
    }
}

