/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.nio;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSession;
import org.apache.hc.core5.http.ConnectionClosedException;
import org.apache.hc.core5.http.ContentLengthStrategy;
import org.apache.hc.core5.http.EndpointDetails;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpConnection;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpMessage;
import org.apache.hc.core5.http.Message;
import org.apache.hc.core5.http.MessageHeaders;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.config.CharCodingConfig;
import org.apache.hc.core5.http.config.Http1Config;
import org.apache.hc.core5.http.impl.BasicEndpointDetails;
import org.apache.hc.core5.http.impl.BasicHttpConnectionMetrics;
import org.apache.hc.core5.http.impl.BasicHttpTransportMetrics;
import org.apache.hc.core5.http.impl.CharCodingSupport;
import org.apache.hc.core5.http.impl.DefaultContentLengthStrategy;
import org.apache.hc.core5.http.impl.IncomingEntityDetails;
import org.apache.hc.core5.http.impl.nio.AbstractHttp1StreamDuplexer$CapacityWindow;
import org.apache.hc.core5.http.impl.nio.AbstractHttp1StreamDuplexer$ConnectionState;
import org.apache.hc.core5.http.impl.nio.AbstractHttp1StreamDuplexer$MessageDelineation;
import org.apache.hc.core5.http.impl.nio.ChunkEncoder;
import org.apache.hc.core5.http.impl.nio.FlushMode;
import org.apache.hc.core5.http.impl.nio.SessionInputBufferImpl;
import org.apache.hc.core5.http.impl.nio.SessionOutputBufferImpl;
import org.apache.hc.core5.http.nio.CapacityChannel;
import org.apache.hc.core5.http.nio.ContentDecoder;
import org.apache.hc.core5.http.nio.ContentEncoder;
import org.apache.hc.core5.http.nio.NHttpMessageParser;
import org.apache.hc.core5.http.nio.NHttpMessageWriter;
import org.apache.hc.core5.http.nio.SessionInputBuffer;
import org.apache.hc.core5.http.nio.SessionOutputBuffer;
import org.apache.hc.core5.http.nio.command.CommandSupport;
import org.apache.hc.core5.http.nio.command.RequestExecutionCommand;
import org.apache.hc.core5.http.nio.command.ShutdownCommand;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.io.SocketTimeoutExceptionFactory;
import org.apache.hc.core5.reactor.Command;
import org.apache.hc.core5.reactor.Command$Priority;
import org.apache.hc.core5.reactor.ProtocolIOSession;
import org.apache.hc.core5.reactor.ssl.TlsDetails;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.Identifiable;
import org.apache.hc.core5.util.Timeout;

abstract class AbstractHttp1StreamDuplexer<IncomingMessage extends HttpMessage, OutgoingMessage extends HttpMessage>
implements HttpConnection,
Identifiable {
    private final ProtocolIOSession ioSession;
    private final Http1Config http1Config;
    private final SessionInputBufferImpl inbuf;
    private final SessionOutputBufferImpl outbuf;
    private final BasicHttpTransportMetrics inTransportMetrics;
    private final BasicHttpTransportMetrics outTransportMetrics;
    private final BasicHttpConnectionMetrics connMetrics;
    private final NHttpMessageParser<IncomingMessage> incomingMessageParser;
    private final NHttpMessageWriter<OutgoingMessage> outgoingMessageWriter;
    private final ContentLengthStrategy incomingContentStrategy;
    private final ContentLengthStrategy outgoingContentStrategy;
    private final ByteBuffer contentBuffer;
    private final AtomicInteger outputRequests;
    private volatile Message<IncomingMessage, ContentDecoder> incomingMessage;
    private volatile Message<OutgoingMessage, ContentEncoder> outgoingMessage;
    private volatile AbstractHttp1StreamDuplexer$ConnectionState connState;
    private volatile AbstractHttp1StreamDuplexer$CapacityWindow capacityWindow;
    private volatile ProtocolVersion version;
    private volatile EndpointDetails endpointDetails;

    AbstractHttp1StreamDuplexer(ProtocolIOSession protocolIOSession, Http1Config http1Config, CharCodingConfig charCodingConfig, NHttpMessageParser<IncomingMessage> nHttpMessageParser, NHttpMessageWriter<OutgoingMessage> nHttpMessageWriter, ContentLengthStrategy contentLengthStrategy, ContentLengthStrategy contentLengthStrategy2) {
        int n2;
        this.ioSession = Args.notNull(protocolIOSession, "I/O session");
        this.http1Config = http1Config != null ? http1Config : Http1Config.DEFAULT;
        int n3 = n2 = this.http1Config.getBufferSize();
        this.inbuf = new SessionInputBufferImpl(n3, Math.min(n3, 512), this.http1Config.getMaxLineLength(), CharCodingSupport.createDecoder(charCodingConfig));
        int n4 = n2;
        this.outbuf = new SessionOutputBufferImpl(n4, Math.min(n4, 512), CharCodingSupport.createEncoder(charCodingConfig));
        this.inTransportMetrics = new BasicHttpTransportMetrics();
        this.outTransportMetrics = new BasicHttpTransportMetrics();
        this.connMetrics = new BasicHttpConnectionMetrics(this.inTransportMetrics, this.outTransportMetrics);
        this.incomingMessageParser = nHttpMessageParser;
        this.outgoingMessageWriter = nHttpMessageWriter;
        this.incomingContentStrategy = contentLengthStrategy != null ? contentLengthStrategy : DefaultContentLengthStrategy.INSTANCE;
        this.outgoingContentStrategy = contentLengthStrategy2 != null ? contentLengthStrategy2 : DefaultContentLengthStrategy.INSTANCE;
        this.contentBuffer = ByteBuffer.allocate(this.http1Config.getBufferSize());
        this.outputRequests = new AtomicInteger(0);
        this.connState = AbstractHttp1StreamDuplexer$ConnectionState.READY;
    }

    @Override
    public String getId() {
        return this.ioSession.getId();
    }

    boolean isActive() {
        return this.connState == AbstractHttp1StreamDuplexer$ConnectionState.ACTIVE;
    }

    boolean isShuttingDown() {
        return this.connState.compareTo(AbstractHttp1StreamDuplexer$ConnectionState.GRACEFUL_SHUTDOWN) >= 0;
    }

    void shutdownSession(CloseMode closeMode) {
        if (closeMode == CloseMode.GRACEFUL) {
            this.connState = AbstractHttp1StreamDuplexer$ConnectionState.GRACEFUL_SHUTDOWN;
            this.ioSession.enqueue(ShutdownCommand.GRACEFUL, Command$Priority.NORMAL);
            return;
        }
        this.connState = AbstractHttp1StreamDuplexer$ConnectionState.SHUTDOWN;
        this.ioSession.close();
    }

    void shutdownSession(Exception object) {
        this.connState = AbstractHttp1StreamDuplexer$ConnectionState.SHUTDOWN;
        try {
            this.terminate((Exception)object);
            return;
        }
        finally {
            object = !(object instanceof ConnectionClosedException) && !(object instanceof SSLHandshakeException) && object instanceof IOException ? CloseMode.IMMEDIATE : CloseMode.GRACEFUL;
            this.ioSession.close((CloseMode)((Object)object));
        }
    }

    abstract void disconnected();

    abstract void terminate(Exception var1);

    abstract void updateInputMetrics(IncomingMessage var1, BasicHttpConnectionMetrics var2);

    abstract void updateOutputMetrics(OutgoingMessage var1, BasicHttpConnectionMetrics var2);

    abstract void consumeHeader(IncomingMessage var1, EntityDetails var2) throws HttpException, IOException;

    abstract boolean handleIncomingMessage(IncomingMessage var1) throws HttpException;

    abstract boolean handleOutgoingMessage(OutgoingMessage var1) throws HttpException;

    abstract ContentDecoder createContentDecoder(long var1, ReadableByteChannel var3, SessionInputBuffer var4, BasicHttpTransportMetrics var5) throws HttpException;

    abstract ContentEncoder createContentEncoder(long var1, WritableByteChannel var3, SessionOutputBuffer var4, BasicHttpTransportMetrics var5) throws HttpException;

    abstract void consumeData(ByteBuffer var1) throws HttpException, IOException;

    abstract void updateCapacity(CapacityChannel var1) throws HttpException, IOException;

    abstract void dataEnd(List<? extends Header> var1) throws HttpException, IOException;

    abstract boolean isOutputReady();

    abstract boolean isRequestInitiated();

    abstract void produceOutput() throws HttpException, IOException;

    abstract void execute(RequestExecutionCommand var1) throws HttpException, IOException;

    abstract void inputEnd() throws HttpException, IOException;

    abstract void outputEnd() throws HttpException, IOException;

    abstract boolean inputIdle();

    abstract boolean outputIdle();

    abstract boolean handleTimeout();

    private void processCommands() throws HttpException, IOException {
        Command command;
        block3: {
            while (true) {
                if ((command = this.ioSession.poll()) == null) {
                    return;
                }
                if (command instanceof ShutdownCommand) {
                    command = (ShutdownCommand)command;
                    this.requestShutdown(((ShutdownCommand)command).getType());
                    continue;
                }
                if (!(command instanceof RequestExecutionCommand)) break block3;
                if (this.connState.compareTo(AbstractHttp1StreamDuplexer$ConnectionState.GRACEFUL_SHUTDOWN) < 0) break;
                command.cancel();
            }
            this.execute((RequestExecutionCommand)command);
            return;
        }
        throw new HttpException("Unexpected command: " + command.getClass());
    }

    public final void onConnect() throws HttpException, IOException {
        if (this.connState == AbstractHttp1StreamDuplexer$ConnectionState.READY) {
            this.connState = AbstractHttp1StreamDuplexer$ConnectionState.ACTIVE;
            this.processCommands();
        }
    }

    IncomingMessage parseMessageHead(boolean bl2) throws IOException, HttpException {
        HttpMessage httpMessage = (HttpMessage)this.incomingMessageParser.parse(this.inbuf, bl2);
        if (httpMessage != null) {
            this.incomingMessageParser.reset();
        }
        return (IncomingMessage)httpMessage;
    }

    public final void onInput(ByteBuffer object) throws HttpException, IOException {
        boolean bl2;
        if (object != null) {
            int bl22 = ((Buffer)object).remaining();
            this.inbuf.put((ByteBuffer)object);
            this.inTransportMetrics.incrementBytesTransferred(bl22);
        }
        if (this.connState.compareTo(AbstractHttp1StreamDuplexer$ConnectionState.GRACEFUL_SHUTDOWN) >= 0 && !this.inbuf.hasData() && this.inputIdle()) {
            this.ioSession.clearEvent(1);
            return;
        }
        boolean bl3 = false;
        if (this.incomingMessage == null) {
            int n2 = this.inbuf.fill(this.ioSession);
            if (n2 > 0) {
                this.inTransportMetrics.incrementBytesTransferred(n2);
            }
            boolean bl4 = bl2 = n2 == -1;
        }
        do {
            if (this.incomingMessage == null) {
                ContentDecoder contentDecoder;
                object = this.parseMessageHead(bl2);
                if (object == null) break;
                this.version = object.getVersion();
                this.updateInputMetrics(object, this.connMetrics);
                if (this.handleIncomingMessage(object)) {
                    long l2 = this.incomingContentStrategy.determineLength((HttpMessage)object);
                    contentDecoder = this.createContentDecoder(l2, this.ioSession, this.inbuf, this.inTransportMetrics);
                    this.consumeHeader(object, contentDecoder != null ? new IncomingEntityDetails((MessageHeaders)object, l2) : null);
                } else {
                    this.consumeHeader(object, null);
                    contentDecoder = null;
                }
                this.capacityWindow = new AbstractHttp1StreamDuplexer$CapacityWindow(this.http1Config.getInitialWindowSize(), this.ioSession);
                if (contentDecoder != null) {
                    this.incomingMessage = new Message<Object, ContentDecoder>(object, contentDecoder);
                } else {
                    this.inputEnd();
                    if (this.connState.compareTo(AbstractHttp1StreamDuplexer$ConnectionState.ACTIVE) == 0) {
                        this.ioSession.setEvent(1);
                    }
                }
            }
            if (this.incomingMessage == null) continue;
            object = this.incomingMessage.getBody();
            int n2 = object.read(this.contentBuffer);
            if (n2 > 0) {
                this.contentBuffer.flip();
                AbstractHttp1StreamDuplexer abstractHttp1StreamDuplexer = this;
                abstractHttp1StreamDuplexer.consumeData(abstractHttp1StreamDuplexer.contentBuffer);
                this.contentBuffer.clear();
                int n3 = this.capacityWindow.removeCapacity(n2);
                if (n3 <= 0 && !object.isCompleted()) {
                    AbstractHttp1StreamDuplexer abstractHttp1StreamDuplexer2 = this;
                    abstractHttp1StreamDuplexer2.updateCapacity(abstractHttp1StreamDuplexer2.capacityWindow);
                }
            }
            if (object.isCompleted()) {
                this.dataEnd(object.getTrailers());
                this.capacityWindow.close();
                this.incomingMessage = null;
                this.ioSession.setEvent(1);
                this.inputEnd();
                continue;
            }
            if (n2 == 0) break;
        } while (this.inbuf.hasData());
        if (bl2 && !this.inbuf.hasData()) {
            if (this.inputIdle()) {
                this.requestShutdown(CloseMode.GRACEFUL);
                return;
            }
            this.shutdownSession(new ConnectionClosedException("Connection closed by peer"));
        }
    }

    public final void onOutput() throws IOException, HttpException {
        int n2;
        this.ioSession.getLock().lock();
        try {
            if (this.outbuf.hasData() && (n2 = this.outbuf.flush(this.ioSession)) > 0) {
                this.outTransportMetrics.incrementBytesTransferred(n2);
            }
        }
        finally {
            this.ioSession.getLock().unlock();
        }
        if (this.connState.compareTo(AbstractHttp1StreamDuplexer$ConnectionState.SHUTDOWN) < 0) {
            n2 = this.outputRequests.get();
            this.produceOutput();
            boolean bl2 = this.isOutputReady();
            this.ioSession.getLock().lock();
            try {
                if (!bl2 && !this.outbuf.hasData() && this.outputRequests.compareAndSet(n2, 0)) {
                    this.ioSession.clearEvent(4);
                } else {
                    this.outputRequests.addAndGet(-n2);
                }
                n2 = this.outgoingMessage == null && !this.outbuf.hasData() && !this.isRequestInitiated() ? 1 : 0;
            }
            finally {
                this.ioSession.getLock().unlock();
            }
            if (n2 != 0) {
                this.outputEnd();
                if (this.connState.compareTo(AbstractHttp1StreamDuplexer$ConnectionState.ACTIVE) == 0) {
                    this.processCommands();
                } else if (this.connState.compareTo(AbstractHttp1StreamDuplexer$ConnectionState.GRACEFUL_SHUTDOWN) >= 0 && this.inputIdle() && this.outputIdle()) {
                    this.connState = AbstractHttp1StreamDuplexer$ConnectionState.SHUTDOWN;
                }
            }
        }
        if (this.connState.compareTo(AbstractHttp1StreamDuplexer$ConnectionState.SHUTDOWN) >= 0) {
            this.ioSession.close();
        }
    }

    public final void onTimeout(Timeout timeout) throws IOException, HttpException {
        if (!this.handleTimeout()) {
            this.onException(SocketTimeoutExceptionFactory.create(timeout));
        }
    }

    public final void onException(Exception exception) {
        this.shutdownSession(exception);
        CommandSupport.failCommands(this.ioSession, exception);
    }

    public final void onDisconnect() {
        this.disconnected();
        CommandSupport.cancelCommands(this.ioSession);
    }

    void requestShutdown(CloseMode closeMode) {
        switch (closeMode) {
            case GRACEFUL: {
                if (this.connState != AbstractHttp1StreamDuplexer$ConnectionState.ACTIVE) break;
                this.connState = AbstractHttp1StreamDuplexer$ConnectionState.GRACEFUL_SHUTDOWN;
                break;
            }
            case IMMEDIATE: {
                this.connState = AbstractHttp1StreamDuplexer$ConnectionState.SHUTDOWN;
            }
        }
        this.ioSession.setEvent(4);
    }

    void commitMessageHead(OutgoingMessage OutgoingMessage, boolean bl2, FlushMode flushMode) throws HttpException, IOException {
        this.ioSession.getLock().lock();
        try {
            int n2;
            this.outgoingMessageWriter.write(OutgoingMessage, this.outbuf);
            this.updateOutputMetrics(OutgoingMessage, this.connMetrics);
            if (!bl2) {
                ContentEncoder contentEncoder;
                if (this.handleOutgoingMessage(OutgoingMessage)) {
                    long l2 = this.outgoingContentStrategy.determineLength((HttpMessage)OutgoingMessage);
                    contentEncoder = this.createContentEncoder(l2, this.ioSession, this.outbuf, this.outTransportMetrics);
                } else {
                    contentEncoder = null;
                }
                if (contentEncoder != null) {
                    this.outgoingMessage = new Message<OutgoingMessage, Object>(OutgoingMessage, contentEncoder);
                }
            }
            this.outgoingMessageWriter.reset();
            if (flushMode == FlushMode.IMMEDIATE && (n2 = this.outbuf.flush(this.ioSession)) > 0) {
                this.outTransportMetrics.incrementBytesTransferred(n2);
            }
            this.ioSession.setEvent(4);
            return;
        }
        finally {
            this.ioSession.getLock().unlock();
        }
    }

    void requestSessionInput() {
        this.ioSession.setEvent(1);
    }

    void requestSessionOutput() {
        this.outputRequests.incrementAndGet();
        this.ioSession.setEvent(4);
    }

    Timeout getSessionTimeout() {
        return this.ioSession.getSocketTimeout();
    }

    void setSessionTimeout(Timeout timeout) {
        this.ioSession.setSocketTimeout(timeout);
    }

    void suspendSessionInput() {
        this.ioSession.clearEvent(1);
    }

    void suspendSessionOutput() throws IOException {
        this.ioSession.getLock().lock();
        try {
            if (this.outbuf.hasData()) {
                int n2 = this.outbuf.flush(this.ioSession);
                if (n2 > 0) {
                    this.outTransportMetrics.incrementBytesTransferred(n2);
                }
            } else {
                this.ioSession.clearEvent(4);
            }
            return;
        }
        finally {
            this.ioSession.getLock().unlock();
        }
    }

    int streamOutput(ByteBuffer byteBuffer) throws IOException {
        this.ioSession.getLock().lock();
        try {
            if (this.outgoingMessage == null) {
                throw new ConnectionClosedException();
            }
            ContentEncoder contentEncoder = this.outgoingMessage.getBody();
            int n2 = contentEncoder.write(byteBuffer);
            if (n2 > 0) {
                this.ioSession.setEvent(4);
            }
            return n2;
        }
        finally {
            this.ioSession.getLock().unlock();
        }
    }

    AbstractHttp1StreamDuplexer$MessageDelineation endOutputStream(List<? extends Header> object) throws IOException {
        this.ioSession.getLock().lock();
        try {
            if (this.outgoingMessage == null) {
                AbstractHttp1StreamDuplexer$MessageDelineation abstractHttp1StreamDuplexer$MessageDelineation = AbstractHttp1StreamDuplexer$MessageDelineation.NONE;
                return abstractHttp1StreamDuplexer$MessageDelineation;
            }
            ContentEncoder contentEncoder = this.outgoingMessage.getBody();
            contentEncoder.complete((List<? extends Header>)object);
            this.ioSession.setEvent(4);
            this.outgoingMessage = null;
            object = contentEncoder instanceof ChunkEncoder ? AbstractHttp1StreamDuplexer$MessageDelineation.CHUNK_CODED : AbstractHttp1StreamDuplexer$MessageDelineation.MESSAGE_HEAD;
            return object;
        }
        finally {
            this.ioSession.getLock().unlock();
        }
    }

    boolean isOutputCompleted() {
        this.ioSession.getLock().lock();
        try {
            if (this.outgoingMessage == null) {
                return true;
            }
            ContentEncoder contentEncoder = this.outgoingMessage.getBody();
            boolean bl2 = contentEncoder.isCompleted();
            return bl2;
        }
        finally {
            this.ioSession.getLock().unlock();
        }
    }

    @Override
    public void close() throws IOException {
        this.ioSession.enqueue(ShutdownCommand.GRACEFUL, Command$Priority.NORMAL);
    }

    @Override
    public void close(CloseMode closeMode) {
        this.ioSession.enqueue(new ShutdownCommand(closeMode), Command$Priority.IMMEDIATE);
    }

    @Override
    public boolean isOpen() {
        return this.connState.compareTo(AbstractHttp1StreamDuplexer$ConnectionState.ACTIVE) <= 0;
    }

    @Override
    public Timeout getSocketTimeout() {
        return this.ioSession.getSocketTimeout();
    }

    @Override
    public void setSocketTimeout(Timeout timeout) {
        this.ioSession.setSocketTimeout(timeout);
    }

    @Override
    public EndpointDetails getEndpointDetails() {
        if (this.endpointDetails == null) {
            this.endpointDetails = new BasicEndpointDetails(this.ioSession.getRemoteAddress(), this.ioSession.getLocalAddress(), this.connMetrics, this.ioSession.getSocketTimeout());
        }
        return this.endpointDetails;
    }

    @Override
    public ProtocolVersion getProtocolVersion() {
        return this.version;
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this.ioSession.getRemoteAddress();
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.ioSession.getLocalAddress();
    }

    @Override
    public SSLSession getSSLSession() {
        TlsDetails tlsDetails = this.ioSession.getTlsDetails();
        if (tlsDetails != null) {
            return tlsDetails.getSSLSession();
        }
        return null;
    }

    void appendState(StringBuilder stringBuilder) {
        stringBuilder.append("connState=").append((Object)this.connState).append(", inbuf=").append(this.inbuf).append(", outbuf=").append(this.outbuf).append(", inputWindow=").append(this.capacityWindow != null ? this.capacityWindow.getWindow() : 0);
    }
}

