/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.nio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.List;
import org.apache.hc.core5.http.FormattedHeader;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.impl.BasicHttpTransportMetrics;
import org.apache.hc.core5.http.impl.nio.AbstractContentEncoder;
import org.apache.hc.core5.http.message.BasicLineFormatter;
import org.apache.hc.core5.http.nio.SessionOutputBuffer;
import org.apache.hc.core5.util.CharArrayBuffer;

public class ChunkEncoder
extends AbstractContentEncoder {
    private final int chunkSizeHint;
    private final CharArrayBuffer lineBuffer;

    public ChunkEncoder(WritableByteChannel writableByteChannel, SessionOutputBuffer sessionOutputBuffer, BasicHttpTransportMetrics basicHttpTransportMetrics, int n2) {
        super(writableByteChannel, sessionOutputBuffer, basicHttpTransportMetrics);
        this.chunkSizeHint = Math.max(n2, 0);
        this.lineBuffer = new CharArrayBuffer(16);
    }

    public ChunkEncoder(WritableByteChannel writableByteChannel, SessionOutputBuffer sessionOutputBuffer, BasicHttpTransportMetrics basicHttpTransportMetrics) {
        this(writableByteChannel, sessionOutputBuffer, basicHttpTransportMetrics, 0);
    }

    @Override
    public int write(ByteBuffer byteBuffer) throws IOException {
        if (byteBuffer == null) {
            return 0;
        }
        this.assertNotCompleted();
        int n2 = 0;
        while (byteBuffer.hasRemaining()) {
            int n3 = byteBuffer.remaining();
            int n4 = this.buffer.capacity();
            if ((n4 -= 12) > 0) {
                if (n4 < n3) {
                    n3 = n4;
                    this.lineBuffer.clear();
                    this.lineBuffer.append(Integer.toHexString(n3));
                    this.buffer.writeLine(this.lineBuffer);
                    n4 = byteBuffer.limit();
                    ByteBuffer byteBuffer2 = byteBuffer;
                    byteBuffer2.limit(byteBuffer2.position() + n3);
                    this.buffer.write(byteBuffer);
                    byteBuffer.limit(n4);
                } else {
                    this.lineBuffer.clear();
                    this.lineBuffer.append(Integer.toHexString(n3));
                    this.buffer.writeLine(this.lineBuffer);
                    this.buffer.write(byteBuffer);
                }
                this.lineBuffer.clear();
                this.buffer.writeLine(this.lineBuffer);
                n2 += n3;
            }
            if (this.buffer.length() < this.chunkSizeHint && !byteBuffer.hasRemaining() || (n4 = this.flushToChannel()) != 0) continue;
        }
        return n2;
    }

    @Override
    public void complete(List<? extends Header> list) throws IOException {
        this.assertNotCompleted();
        this.lineBuffer.clear();
        this.lineBuffer.append("0");
        this.buffer.writeLine(this.lineBuffer);
        this.writeTrailers(list);
        this.lineBuffer.clear();
        this.buffer.writeLine(this.lineBuffer);
        super.complete(list);
    }

    private void writeTrailers(List<? extends Header> list) throws IOException {
        if (list != null) {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                Object object = list.get(i2);
                if (object instanceof FormattedHeader) {
                    object = ((FormattedHeader)object).getBuffer();
                    this.buffer.writeLine((CharArrayBuffer)object);
                    continue;
                }
                this.lineBuffer.clear();
                BasicLineFormatter.INSTANCE.formatHeader(this.lineBuffer, (Header)object);
                this.buffer.writeLine(this.lineBuffer);
            }
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[chunk-coded; completed: ");
        stringBuilder.append(this.isCompleted());
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

