/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.nio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.http.ConnectionClosedException;
import org.apache.hc.core5.http.ConnectionReuseStrategy;
import org.apache.hc.core5.http.ContentLengthStrategy;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.LengthRequiredException;
import org.apache.hc.core5.http.config.CharCodingConfig;
import org.apache.hc.core5.http.config.Http1Config;
import org.apache.hc.core5.http.impl.BasicHttpConnectionMetrics;
import org.apache.hc.core5.http.impl.BasicHttpTransportMetrics;
import org.apache.hc.core5.http.impl.DefaultConnectionReuseStrategy;
import org.apache.hc.core5.http.impl.Http1StreamListener;
import org.apache.hc.core5.http.impl.nio.AbstractHttp1StreamDuplexer;
import org.apache.hc.core5.http.impl.nio.ChunkDecoder;
import org.apache.hc.core5.http.impl.nio.ChunkEncoder;
import org.apache.hc.core5.http.impl.nio.ClientHttp1StreamDuplexer$1;
import org.apache.hc.core5.http.impl.nio.ClientHttp1StreamHandler;
import org.apache.hc.core5.http.impl.nio.Http1StreamChannel;
import org.apache.hc.core5.http.impl.nio.IdentityDecoder;
import org.apache.hc.core5.http.impl.nio.LengthDelimitedDecoder;
import org.apache.hc.core5.http.impl.nio.LengthDelimitedEncoder;
import org.apache.hc.core5.http.message.MessageSupport;
import org.apache.hc.core5.http.nio.AsyncClientExchangeHandler;
import org.apache.hc.core5.http.nio.CapacityChannel;
import org.apache.hc.core5.http.nio.ContentDecoder;
import org.apache.hc.core5.http.nio.ContentEncoder;
import org.apache.hc.core5.http.nio.NHttpMessageParser;
import org.apache.hc.core5.http.nio.NHttpMessageWriter;
import org.apache.hc.core5.http.nio.SessionInputBuffer;
import org.apache.hc.core5.http.nio.SessionOutputBuffer;
import org.apache.hc.core5.http.nio.command.RequestExecutionCommand;
import org.apache.hc.core5.http.protocol.HttpCoreContext;
import org.apache.hc.core5.http.protocol.HttpProcessor;
import org.apache.hc.core5.reactor.ProtocolIOSession;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.Asserts;

@Internal
public class ClientHttp1StreamDuplexer
extends AbstractHttp1StreamDuplexer<HttpResponse, HttpRequest> {
    private final HttpProcessor httpProcessor;
    private final ConnectionReuseStrategy connectionReuseStrategy;
    private final Http1Config http1Config;
    private final Http1StreamListener streamListener;
    private final Queue<ClientHttp1StreamHandler> pipeline;
    private final Http1StreamChannel<HttpRequest> outputChannel;
    private volatile ClientHttp1StreamHandler outgoing;
    private volatile ClientHttp1StreamHandler incoming;

    public ClientHttp1StreamDuplexer(ProtocolIOSession protocolIOSession, HttpProcessor httpProcessor, Http1Config http1Config, CharCodingConfig charCodingConfig, ConnectionReuseStrategy connectionReuseStrategy, NHttpMessageParser<HttpResponse> nHttpMessageParser, NHttpMessageWriter<HttpRequest> nHttpMessageWriter, ContentLengthStrategy contentLengthStrategy, ContentLengthStrategy contentLengthStrategy2, Http1StreamListener http1StreamListener) {
        super(protocolIOSession, http1Config, charCodingConfig, nHttpMessageParser, nHttpMessageWriter, contentLengthStrategy, contentLengthStrategy2);
        this.httpProcessor = Args.notNull(httpProcessor, "HTTP processor");
        this.http1Config = http1Config != null ? http1Config : Http1Config.DEFAULT;
        this.connectionReuseStrategy = connectionReuseStrategy != null ? connectionReuseStrategy : DefaultConnectionReuseStrategy.INSTANCE;
        this.streamListener = http1StreamListener;
        this.pipeline = new ConcurrentLinkedQueue<ClientHttp1StreamHandler>();
        this.outputChannel = new ClientHttp1StreamDuplexer$1(this, http1StreamListener);
    }

    @Override
    void terminate(Exception exception) {
        ClientHttp1StreamHandler clientHttp1StreamHandler;
        if (this.incoming != null) {
            this.incoming.failed(exception);
            this.incoming.releaseResources();
            this.incoming = null;
        }
        if (this.outgoing != null) {
            this.outgoing.failed(exception);
            this.outgoing.releaseResources();
            this.outgoing = null;
        }
        while ((clientHttp1StreamHandler = this.pipeline.poll()) != null) {
            clientHttp1StreamHandler.failed(exception);
            clientHttp1StreamHandler.releaseResources();
        }
    }

    @Override
    void disconnected() {
        ClientHttp1StreamHandler clientHttp1StreamHandler;
        if (this.incoming != null) {
            if (!this.incoming.isCompleted()) {
                this.incoming.failed(new ConnectionClosedException());
            }
            this.incoming.releaseResources();
            this.incoming = null;
        }
        if (this.outgoing != null) {
            if (!this.outgoing.isCompleted()) {
                this.outgoing.failed(new ConnectionClosedException());
            }
            this.outgoing.releaseResources();
            this.outgoing = null;
        }
        while ((clientHttp1StreamHandler = this.pipeline.poll()) != null) {
            clientHttp1StreamHandler.failed(new ConnectionClosedException());
            clientHttp1StreamHandler.releaseResources();
        }
    }

    @Override
    void updateInputMetrics(HttpResponse httpResponse, BasicHttpConnectionMetrics basicHttpConnectionMetrics) {
        if (httpResponse.getCode() >= 200) {
            basicHttpConnectionMetrics.incrementRequestCount();
        }
    }

    @Override
    void updateOutputMetrics(HttpRequest httpRequest, BasicHttpConnectionMetrics basicHttpConnectionMetrics) {
        basicHttpConnectionMetrics.incrementRequestCount();
    }

    @Override
    protected boolean handleIncomingMessage(HttpResponse httpResponse) throws HttpException {
        if (this.incoming == null) {
            this.incoming = this.pipeline.poll();
        }
        if (this.incoming == null) {
            throw new HttpException("Unexpected response");
        }
        return MessageSupport.canResponseHaveBody(this.incoming.getRequestMethod(), httpResponse);
    }

    @Override
    protected ContentDecoder createContentDecoder(long l2, ReadableByteChannel readableByteChannel, SessionInputBuffer sessionInputBuffer, BasicHttpTransportMetrics basicHttpTransportMetrics) throws HttpException {
        if (l2 >= 0L) {
            return new LengthDelimitedDecoder(readableByteChannel, sessionInputBuffer, basicHttpTransportMetrics, l2);
        }
        if (l2 == -1L) {
            return new ChunkDecoder(readableByteChannel, sessionInputBuffer, this.http1Config, basicHttpTransportMetrics);
        }
        return new IdentityDecoder(readableByteChannel, sessionInputBuffer, basicHttpTransportMetrics);
    }

    @Override
    protected boolean handleOutgoingMessage(HttpRequest httpRequest) throws HttpException {
        return true;
    }

    @Override
    protected ContentEncoder createContentEncoder(long l2, WritableByteChannel writableByteChannel, SessionOutputBuffer sessionOutputBuffer, BasicHttpTransportMetrics basicHttpTransportMetrics) throws HttpException {
        int n2;
        int n3 = n2 = this.http1Config.getChunkSizeHint() >= 0 ? this.http1Config.getChunkSizeHint() : 2048;
        if (l2 >= 0L) {
            return new LengthDelimitedEncoder(writableByteChannel, sessionOutputBuffer, basicHttpTransportMetrics, l2, n2);
        }
        if (l2 == -1L) {
            return new ChunkEncoder(writableByteChannel, sessionOutputBuffer, basicHttpTransportMetrics, n2);
        }
        throw new LengthRequiredException();
    }

    @Override
    boolean isRequestInitiated() {
        return this.outgoing != null && !this.outgoing.isRequestFinal();
    }

    @Override
    boolean inputIdle() {
        return this.incoming == null && this.pipeline.isEmpty();
    }

    @Override
    boolean outputIdle() {
        return this.outgoing == null;
    }

    @Override
    void outputEnd() throws HttpException, IOException {
        if (this.outgoing != null) {
            if (this.outgoing.isCompleted()) {
                this.outgoing.releaseResources();
            }
            this.outgoing = null;
        }
    }

    @Override
    void execute(RequestExecutionCommand object) throws HttpException, IOException {
        AsyncClientExchangeHandler asyncClientExchangeHandler = ((RequestExecutionCommand)object).getExchangeHandler();
        object = HttpCoreContext.castOrCreate(((RequestExecutionCommand)object).getContext());
        ((HttpCoreContext)object).setSSLSession(this.getSSLSession());
        ((HttpCoreContext)object).setEndpointDetails(this.getEndpointDetails());
        object = new ClientHttp1StreamHandler(this.outputChannel, this.httpProcessor, this.http1Config, this.connectionReuseStrategy, asyncClientExchangeHandler, (HttpCoreContext)object);
        this.pipeline.add((ClientHttp1StreamHandler)object);
        this.outgoing = object;
        if (((ClientHttp1StreamHandler)object).isOutputReady()) {
            ((ClientHttp1StreamHandler)object).produceOutput();
        }
    }

    @Override
    boolean isOutputReady() {
        return this.outgoing != null && this.outgoing.isOutputReady();
    }

    @Override
    void produceOutput() throws HttpException, IOException {
        if (this.outgoing != null) {
            this.outgoing.produceOutput();
        }
    }

    @Override
    void consumeHeader(HttpResponse httpResponse, EntityDetails entityDetails) throws HttpException, IOException {
        if (this.streamListener != null) {
            this.streamListener.onResponseHead(this, httpResponse);
        }
        Asserts.notNull(this.incoming, "Response stream handler");
        this.incoming.consumeHeader(httpResponse, entityDetails);
    }

    @Override
    void consumeData(ByteBuffer byteBuffer) throws HttpException, IOException {
        Asserts.notNull(this.incoming, "Response stream handler");
        this.incoming.consumeData(byteBuffer);
    }

    @Override
    void updateCapacity(CapacityChannel capacityChannel) throws HttpException, IOException {
        Asserts.notNull(this.incoming, "Response stream handler");
        this.incoming.updateCapacity(capacityChannel);
    }

    @Override
    void dataEnd(List<? extends Header> list) throws HttpException, IOException {
        Asserts.notNull(this.incoming, "Response stream handler");
        this.incoming.dataEnd(list);
    }

    @Override
    void inputEnd() throws HttpException, IOException {
        if (this.incoming != null && this.incoming.isResponseFinal()) {
            if (this.streamListener != null) {
                ClientHttp1StreamDuplexer clientHttp1StreamDuplexer = this;
                this.streamListener.onExchangeComplete(clientHttp1StreamDuplexer, clientHttp1StreamDuplexer.isOpen());
            }
            if (this.incoming.isCompleted()) {
                this.incoming.releaseResources();
            }
            this.incoming = null;
        }
    }

    @Override
    boolean handleTimeout() {
        return this.outgoing != null && this.outgoing.handleTimeout();
    }

    @Override
    void appendState(StringBuilder stringBuilder) {
        super.appendState(stringBuilder);
        stringBuilder.append(", incoming=[");
        if (this.incoming != null) {
            this.incoming.appendState(stringBuilder);
        }
        stringBuilder.append("], outgoing=[");
        if (this.outgoing != null) {
            this.outgoing.appendState(stringBuilder);
        }
        stringBuilder.append("], pipeline=");
        stringBuilder.append(this.pipeline.size());
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        this.appendState(stringBuilder);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

