/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.nio;

import java.io.IOException;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.config.Http1Config;
import org.apache.hc.core5.http.impl.nio.AbstractMessageWriter;
import org.apache.hc.core5.http.message.LineFormatter;
import org.apache.hc.core5.http.message.StatusLine;
import org.apache.hc.core5.util.CharArrayBuffer;

public class DefaultHttpResponseWriter<T extends HttpResponse>
extends AbstractMessageWriter<T> {
    private final Http1Config http1Config;

    public DefaultHttpResponseWriter(LineFormatter lineFormatter, Http1Config http1Config) {
        super(lineFormatter);
        this.http1Config = http1Config != null ? http1Config : Http1Config.DEFAULT;
    }

    public DefaultHttpResponseWriter(LineFormatter lineFormatter) {
        this(lineFormatter, null);
    }

    public DefaultHttpResponseWriter() {
        this(null, null);
    }

    protected HttpVersion protocolVersion(T t2) {
        return this.http1Config.getVersion();
    }

    @Override
    protected void writeHeadLine(T t2, CharArrayBuffer charArrayBuffer) throws IOException {
        charArrayBuffer.clear();
        this.getLineFormatter().formatStatusLine(charArrayBuffer, new StatusLine(this.protocolVersion(t2), t2.getCode(), t2.getReasonPhrase()));
    }
}

