/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.nio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import org.apache.hc.core5.http.impl.BasicHttpTransportMetrics;
import org.apache.hc.core5.http.impl.nio.AbstractContentDecoder;
import org.apache.hc.core5.http.nio.FileContentDecoder;
import org.apache.hc.core5.http.nio.SessionInputBuffer;
import org.apache.hc.core5.util.Args;

public class IdentityDecoder
extends AbstractContentDecoder
implements FileContentDecoder {
    public IdentityDecoder(ReadableByteChannel readableByteChannel, SessionInputBuffer sessionInputBuffer, BasicHttpTransportMetrics basicHttpTransportMetrics) {
        super(readableByteChannel, sessionInputBuffer, basicHttpTransportMetrics);
    }

    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        Args.notNull(byteBuffer, "Byte buffer");
        if (this.isCompleted()) {
            return -1;
        }
        int n2 = this.buffer.hasData() ? this.buffer.read(byteBuffer) : this.readFromChannel(byteBuffer);
        if (n2 == -1) {
            this.setCompleted();
        }
        return n2;
    }

    @Override
    public long transfer(FileChannel fileChannel, long l2, long l3) throws IOException {
        long l4;
        if (fileChannel == null) {
            return 0L;
        }
        if (this.isCompleted()) {
            return 0L;
        }
        if (this.buffer.hasData()) {
            int n2 = this.buffer.length();
            fileChannel.position(l2);
            l4 = this.buffer.read(fileChannel, l3 < (long)n2 ? (int)l3 : n2);
        } else {
            if (this.channel.isOpen()) {
                if (l2 > fileChannel.size()) {
                    throw new IOException("Position past end of file [" + l2 + " > " + fileChannel.size() + "]");
                }
                l4 = fileChannel.transferFrom(this.channel, l2, l3);
                if (l3 > 0L && l4 == 0L) {
                    l4 = this.buffer.fill(this.channel);
                }
            } else {
                l4 = -1L;
            }
            if (l4 > 0L) {
                this.metrics.incrementBytesTransferred(l4);
            }
        }
        if (l4 == -1L) {
            this.setCompleted();
        }
        return l4;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[identity; completed: ");
        stringBuilder.append(this.completed);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

