/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.nio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import org.apache.hc.core5.http.ConnectionClosedException;
import org.apache.hc.core5.http.impl.BasicHttpTransportMetrics;
import org.apache.hc.core5.http.impl.nio.AbstractContentDecoder;
import org.apache.hc.core5.http.nio.FileContentDecoder;
import org.apache.hc.core5.http.nio.SessionInputBuffer;
import org.apache.hc.core5.util.Args;

public class LengthDelimitedDecoder
extends AbstractContentDecoder
implements FileContentDecoder {
    private final long contentLength;
    private long len;

    public LengthDelimitedDecoder(ReadableByteChannel readableByteChannel, SessionInputBuffer sessionInputBuffer, BasicHttpTransportMetrics basicHttpTransportMetrics, long l2) {
        super(readableByteChannel, sessionInputBuffer, basicHttpTransportMetrics);
        Args.notNegative(l2, "Content length");
        this.contentLength = l2;
    }

    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        int n2;
        Args.notNull(byteBuffer, "Byte buffer");
        if (this.isCompleted()) {
            return -1;
        }
        int n3 = (int)Math.min(this.contentLength - this.len, Integer.MAX_VALUE);
        if (this.buffer.hasData()) {
            n3 = Math.min(n3, this.buffer.length());
            n2 = this.buffer.read(byteBuffer, n3);
        } else {
            n2 = this.readFromChannel(byteBuffer, n3);
        }
        if (n2 == -1) {
            this.setCompleted();
            if (this.len < this.contentLength) {
                throw new ConnectionClosedException("Premature end of Content-Length delimited message body (expected: %d; received: %d)", this.contentLength, this.len);
            }
        }
        this.len += (long)n2;
        if (this.len >= this.contentLength) {
            this.completed = true;
        }
        if (this.completed && n2 == 0) {
            return -1;
        }
        return n2;
    }

    @Override
    public long transfer(FileChannel fileChannel, long l2, long l3) throws IOException {
        long l4;
        if (fileChannel == null) {
            return 0L;
        }
        if (this.isCompleted()) {
            return -1L;
        }
        int n2 = (int)Math.min(this.contentLength - this.len, Integer.MAX_VALUE);
        if (this.buffer.hasData()) {
            n2 = Math.min(n2, this.buffer.length());
            fileChannel.position(l2);
            l4 = this.buffer.read(fileChannel, l3 < (long)n2 ? (int)l3 : n2);
        } else {
            if (this.channel.isOpen()) {
                if (l2 > fileChannel.size()) {
                    throw new IOException(String.format("Position past end of file [%d > %d]", l2, fileChannel.size()));
                }
                l4 = fileChannel.transferFrom(this.channel, l2, l3 < (long)n2 ? l3 : (long)n2);
            } else {
                l4 = -1L;
            }
            if (l4 > 0L) {
                this.metrics.incrementBytesTransferred(l4);
            }
        }
        if (l4 == -1L) {
            this.setCompleted();
            if (this.len < this.contentLength) {
                throw new ConnectionClosedException("Premature end of Content-Length delimited message body (expected: %d; received: %d)", this.contentLength, this.len);
            }
        }
        this.len += l4;
        if (this.len >= this.contentLength) {
            this.completed = true;
        }
        return l4;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[content length: ");
        stringBuilder.append(this.contentLength);
        stringBuilder.append("; pos: ");
        stringBuilder.append(this.len);
        stringBuilder.append("; completed: ");
        stringBuilder.append(this.completed);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

