/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.nio;

import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.URIScheme;
import org.apache.hc.core5.http.impl.nio.ServerHttp1IOEventHandler;
import org.apache.hc.core5.http.impl.nio.ServerHttp1StreamDuplexerFactory;
import org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import org.apache.hc.core5.net.NamedEndpoint;
import org.apache.hc.core5.reactor.EndpointParameters;
import org.apache.hc.core5.reactor.IOEventHandler;
import org.apache.hc.core5.reactor.IOEventHandlerFactory;
import org.apache.hc.core5.reactor.ProtocolIOSession;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.Timeout;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class ServerHttp1IOEventHandlerFactory
implements IOEventHandlerFactory {
    private final ServerHttp1StreamDuplexerFactory streamDuplexerFactory;
    private final TlsStrategy tlsStrategy;
    private final Timeout handshakeTimeout;

    public ServerHttp1IOEventHandlerFactory(ServerHttp1StreamDuplexerFactory serverHttp1StreamDuplexerFactory, TlsStrategy tlsStrategy, Timeout timeout) {
        this.streamDuplexerFactory = Args.notNull(serverHttp1StreamDuplexerFactory, "Stream duplexer factory");
        this.tlsStrategy = tlsStrategy;
        this.handshakeTimeout = timeout;
    }

    @Override
    public IOEventHandler createHandler(ProtocolIOSession protocolIOSession, Object object) {
        String string = URIScheme.HTTP.id;
        if (this.tlsStrategy != null) {
            if (object instanceof EndpointParameters) {
                string = ((EndpointParameters)(object = (EndpointParameters)object)).getScheme();
                if (URIScheme.HTTPS.same(string)) {
                    Object object2 = object;
                    this.tlsStrategy.upgrade(protocolIOSession, (NamedEndpoint)object2, ((EndpointParameters)object2).getAttachment(), this.handshakeTimeout, null);
                }
            } else {
                string = URIScheme.HTTPS.id;
                this.tlsStrategy.upgrade(protocolIOSession, null, object, this.handshakeTimeout, null);
            }
        }
        return new ServerHttp1IOEventHandler(this.streamDuplexerFactory.create(string, protocolIOSession));
    }
}

