/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.nio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import org.apache.hc.core5.http.MessageConstraintException;
import org.apache.hc.core5.http.impl.nio.ExpandableBuffer;
import org.apache.hc.core5.http.nio.SessionInputBuffer;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.CharArrayBuffer;

class SessionInputBufferImpl
extends ExpandableBuffer
implements SessionInputBuffer {
    private final CharsetDecoder charDecoder;
    private final int lineBuffersize;
    private final int maxLineLen;
    private CharBuffer charbuffer;

    public SessionInputBufferImpl(int n2, int n3, int n4, CharsetDecoder charsetDecoder) {
        super(n2);
        this.lineBuffersize = Args.positive(n3, "Line buffer size");
        this.maxLineLen = Math.max(n4, 0);
        this.charDecoder = charsetDecoder;
    }

    public SessionInputBufferImpl(int n2, int n3, int n4, Charset charset) {
        this(n2, n3, n4, charset != null ? charset.newDecoder() : null);
    }

    public SessionInputBufferImpl(int n2, int n3, int n4) {
        this(n2, n3, n4, (CharsetDecoder)null);
    }

    public SessionInputBufferImpl(int n2, int n3) {
        this(n2, n3, 0, (CharsetDecoder)null);
    }

    public SessionInputBufferImpl(int n2) {
        this(n2, 256);
    }

    @Override
    public int length() {
        return super.length();
    }

    @Override
    public boolean hasData() {
        return super.hasData();
    }

    @Override
    public int capacity() {
        return super.capacity();
    }

    public void put(ByteBuffer byteBuffer) {
        if (byteBuffer != null && byteBuffer.hasRemaining()) {
            this.setInputMode();
            SessionInputBufferImpl sessionInputBufferImpl = this;
            sessionInputBufferImpl.ensureAdjustedCapacity(sessionInputBufferImpl.buffer().position() + byteBuffer.remaining());
            this.buffer().put(byteBuffer);
        }
    }

    @Override
    public int fill(ReadableByteChannel readableByteChannel) throws IOException {
        Args.notNull(readableByteChannel, "Channel");
        this.setInputMode();
        if (!this.buffer().hasRemaining()) {
            this.expand();
        }
        return readableByteChannel.read(this.buffer());
    }

    @Override
    public int read() {
        this.setOutputMode();
        return this.buffer().get() & 0xFF;
    }

    @Override
    public int read(ByteBuffer byteBuffer, int n2) {
        if (byteBuffer == null) {
            return 0;
        }
        this.setOutputMode();
        n2 = Math.min(byteBuffer.remaining(), n2);
        int n3 = Math.min(this.buffer().remaining(), n2);
        if (this.buffer().remaining() > n3) {
            int n4 = this.buffer().limit();
            n3 = this.buffer().position() + n3;
            this.buffer().limit(n3);
            byteBuffer.put(this.buffer());
            this.buffer().limit(n4);
            return n2;
        }
        byteBuffer.put(this.buffer());
        return n3;
    }

    @Override
    public int read(ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            return 0;
        }
        ByteBuffer byteBuffer2 = byteBuffer;
        return this.read(byteBuffer2, byteBuffer2.remaining());
    }

    @Override
    public int read(WritableByteChannel writableByteChannel, int n2) throws IOException {
        int n3;
        if (writableByteChannel == null) {
            return 0;
        }
        this.setOutputMode();
        if (this.buffer().remaining() > n2) {
            int n4 = this.buffer().limit();
            n2 = n4 - (this.buffer().remaining() - n2);
            this.buffer().limit(n2);
            n3 = writableByteChannel.write(this.buffer());
            this.buffer().limit(n4);
        } else {
            n3 = writableByteChannel.write(this.buffer());
        }
        return n3;
    }

    @Override
    public int read(WritableByteChannel writableByteChannel) throws IOException {
        if (writableByteChannel == null) {
            return 0;
        }
        this.setOutputMode();
        return writableByteChannel.write(this.buffer());
    }

    @Override
    public boolean readLine(CharArrayBuffer charArrayBuffer, boolean bl2) throws IOException {
        int n2;
        int n3;
        this.setOutputMode();
        int n4 = -1;
        for (n3 = this.buffer().position(); n3 < this.buffer().limit(); ++n3) {
            n2 = this.buffer().get(n3);
            if (n2 != 10) continue;
            n4 = n3 + 1;
            break;
        }
        if (this.maxLineLen > 0 && (n3 = (n4 > 0 ? n4 : this.buffer().limit()) - this.buffer().position()) >= this.maxLineLen) {
            throw new MessageConstraintException("Maximum line length limit exceeded");
        }
        if (n4 == -1) {
            if (bl2 && this.buffer().hasRemaining()) {
                n4 = this.buffer().limit();
            } else {
                return false;
            }
        }
        n3 = this.buffer().limit();
        this.buffer().limit(n4);
        n2 = this.buffer().limit() - this.buffer().position();
        charArrayBuffer.ensureCapacity(n2);
        if (this.charDecoder == null) {
            if (this.buffer().hasArray()) {
                byte[] byArray = this.buffer().array();
                n4 = this.buffer().position();
                n2 = this.buffer().remaining();
                charArrayBuffer.append(byArray, this.buffer().arrayOffset() + n4, n2);
                this.buffer().position(n4 + n2);
            } else {
                while (this.buffer().hasRemaining()) {
                    charArrayBuffer.append((char)(this.buffer().get() & 0xFF));
                }
            }
        } else {
            CoderResult coderResult;
            if (this.charbuffer == null) {
                this.charbuffer = CharBuffer.allocate(this.lineBuffersize);
            }
            this.charDecoder.reset();
            do {
                if ((coderResult = this.charDecoder.decode(this.buffer(), this.charbuffer, true)).isError()) {
                    coderResult.throwException();
                }
                if (!coderResult.isOverflow()) continue;
                this.charbuffer.flip();
                charArrayBuffer.append(this.charbuffer.array(), this.charbuffer.arrayOffset() + this.charbuffer.position(), this.charbuffer.remaining());
                this.charbuffer.clear();
            } while (!coderResult.isUnderflow());
            this.charDecoder.flush(this.charbuffer);
            this.charbuffer.flip();
            if (this.charbuffer.hasRemaining()) {
                charArrayBuffer.append(this.charbuffer.array(), this.charbuffer.arrayOffset() + this.charbuffer.position(), this.charbuffer.remaining());
            }
        }
        this.buffer().limit(n3);
        int n5 = charArrayBuffer.length();
        if (n5 > 0) {
            if (charArrayBuffer.charAt(n5 - 1) == '\n') {
                charArrayBuffer.setLength(--n5);
            }
            if (n5 > 0 && charArrayBuffer.charAt(n5 - 1) == '\r') {
                charArrayBuffer.setLength(--n5);
            }
        }
        return true;
    }
}

