/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.nio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import org.apache.hc.core5.http.impl.nio.ExpandableBuffer;
import org.apache.hc.core5.http.nio.SessionOutputBuffer;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.CharArrayBuffer;
import org.apache.hc.core5.util.TextUtils;

class SessionOutputBufferImpl
extends ExpandableBuffer
implements SessionOutputBuffer {
    private static final byte[] CRLF = new byte[]{13, 10};
    private final CharsetEncoder charEncoder;
    private final int lineBufferSize;
    private CharBuffer charbuffer;

    public SessionOutputBufferImpl(int n2, int n3, CharsetEncoder charsetEncoder) {
        super(n2);
        this.lineBufferSize = Args.positive(n3, "Line buffer size");
        this.charEncoder = charsetEncoder;
    }

    public SessionOutputBufferImpl(int n2, int n3, Charset charset) {
        this(n2, n3, charset != null ? charset.newEncoder() : null);
    }

    public SessionOutputBufferImpl(int n2, int n3) {
        this(n2, n3, (CharsetEncoder)null);
    }

    public SessionOutputBufferImpl(int n2) {
        this(n2, 256);
    }

    @Override
    public int length() {
        return super.length();
    }

    @Override
    public boolean hasData() {
        return super.hasData();
    }

    @Override
    public int capacity() {
        return super.capacity();
    }

    @Override
    public int flush(WritableByteChannel writableByteChannel) throws IOException {
        Args.notNull(writableByteChannel, "Channel");
        this.setOutputMode();
        return writableByteChannel.write(this.buffer());
    }

    @Override
    public void write(ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            return;
        }
        this.setInputMode();
        SessionOutputBufferImpl sessionOutputBufferImpl = this;
        sessionOutputBufferImpl.ensureAdjustedCapacity(sessionOutputBufferImpl.buffer().position() + byteBuffer.remaining());
        this.buffer().put(byteBuffer);
    }

    @Override
    public void write(ReadableByteChannel readableByteChannel) throws IOException {
        if (readableByteChannel == null) {
            return;
        }
        this.setInputMode();
        readableByteChannel.read(this.buffer());
    }

    private void write(byte[] byArray) {
        if (byArray == null) {
            return;
        }
        this.setInputMode();
        int n2 = byArray.length;
        int n3 = this.buffer().position() + n2;
        this.ensureAdjustedCapacity(n3);
        this.buffer().put(byArray, 0, n2);
    }

    private void writeCRLF() {
        this.write(CRLF);
    }

    @Override
    public void writeLine(CharArrayBuffer charArrayBuffer) throws CharacterCodingException {
        if (charArrayBuffer == null) {
            return;
        }
        this.setInputMode();
        if (charArrayBuffer.length() > 0) {
            if (this.charEncoder == null) {
                int n2 = this.buffer().position() + charArrayBuffer.length();
                this.ensureCapacity(n2);
                if (this.buffer().hasArray()) {
                    byte[] byArray = this.buffer().array();
                    int n3 = charArrayBuffer.length();
                    int n4 = this.buffer().position();
                    int n5 = this.buffer().arrayOffset();
                    for (int i2 = 0; i2 < n3; ++i2) {
                        n2 = charArrayBuffer.charAt(i2);
                        byArray[n5 + n4 + i2] = TextUtils.castAsByte(n2);
                    }
                    this.buffer().position(n4 + n3);
                } else {
                    for (int i3 = 0; i3 < charArrayBuffer.length(); ++i3) {
                        char c2 = charArrayBuffer.charAt(i3);
                        this.buffer().put(TextUtils.castAsByte(c2));
                    }
                }
            } else {
                int n6;
                if (this.charbuffer == null) {
                    this.charbuffer = CharBuffer.allocate(this.lineBufferSize);
                }
                this.charEncoder.reset();
                int n7 = 0;
                for (int i4 = charArrayBuffer.length(); i4 > 0; i4 -= n6) {
                    n6 = this.charbuffer.remaining();
                    boolean bl2 = false;
                    if (i4 <= n6) {
                        n6 = i4;
                        bl2 = true;
                    }
                    this.charbuffer.put(charArrayBuffer.array(), n7, n6);
                    this.charbuffer.flip();
                    boolean bl3 = true;
                    while (bl3) {
                        CoderResult coderResult = this.charEncoder.encode(this.charbuffer, this.buffer(), bl2);
                        if (coderResult.isError()) {
                            coderResult.throwException();
                        }
                        if (coderResult.isOverflow()) {
                            this.expand();
                        }
                        bl3 = !coderResult.isUnderflow();
                    }
                    this.charbuffer.compact();
                    n7 += n6;
                }
                n6 = 1;
                while (n6 != 0) {
                    CoderResult coderResult = this.charEncoder.flush(this.buffer());
                    if (coderResult.isError()) {
                        coderResult.throwException();
                    }
                    if (coderResult.isOverflow()) {
                        this.expand();
                    }
                    n6 = !coderResult.isUnderflow() ? 1 : 0;
                }
            }
        }
        this.writeCRLF();
    }
}

