/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.io;

import java.io.IOException;
import java.io.InputStream;
import org.apache.hc.core5.http.io.EofSensorWatcher;
import org.apache.hc.core5.util.Args;

public class EofSensorInputStream
extends InputStream {
    private InputStream wrappedStream;
    private boolean selfClosed;
    private final EofSensorWatcher eofWatcher;

    public EofSensorInputStream(InputStream inputStream, EofSensorWatcher eofSensorWatcher) {
        Args.notNull(inputStream, "Wrapped stream");
        this.wrappedStream = inputStream;
        this.selfClosed = false;
        this.eofWatcher = eofSensorWatcher;
    }

    boolean isSelfClosed() {
        return this.selfClosed;
    }

    InputStream getWrappedStream() {
        return this.wrappedStream;
    }

    private boolean isReadAllowed() throws IOException {
        if (this.selfClosed) {
            throw new IOException("Attempted read on closed stream.");
        }
        return this.wrappedStream != null;
    }

    @Override
    public int read() throws IOException {
        int n2 = -1;
        if (this.isReadAllowed()) {
            try {
                n2 = this.wrappedStream.read();
                this.checkEOF(n2);
            }
            catch (IOException iOException) {
                this.checkAbort();
                throw iOException;
            }
        }
        return n2;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        if (n3 == 0) {
            return 0;
        }
        int n4 = -1;
        if (this.isReadAllowed()) {
            try {
                n4 = this.wrappedStream.read(byArray, n2, n3);
                this.checkEOF(n4);
            }
            catch (IOException iOException) {
                this.checkAbort();
                throw iOException;
            }
        }
        return n4;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int available() throws IOException {
        int n2 = 0;
        if (this.isReadAllowed()) {
            try {
                n2 = this.wrappedStream.available();
            }
            catch (IOException iOException) {
                this.checkAbort();
                throw iOException;
            }
        }
        return n2;
    }

    @Override
    public void close() throws IOException {
        this.selfClosed = true;
        this.checkClose();
    }

    private void checkEOF(int n2) throws IOException {
        InputStream inputStream = this.wrappedStream;
        if (inputStream != null && n2 < 0) {
            try {
                n2 = 1;
                if (this.eofWatcher != null) {
                    n2 = this.eofWatcher.eofDetected(inputStream) ? 1 : 0;
                }
                if (n2 != 0) {
                    inputStream.close();
                }
                return;
            }
            finally {
                this.wrappedStream = null;
            }
        }
    }

    private void checkClose() throws IOException {
        InputStream inputStream = this.wrappedStream;
        if (inputStream != null) {
            try {
                boolean bl2 = true;
                if (this.eofWatcher != null) {
                    bl2 = this.eofWatcher.streamClosed(inputStream);
                }
                if (bl2) {
                    inputStream.close();
                }
                return;
            }
            finally {
                this.wrappedStream = null;
            }
        }
    }

    private void checkAbort() throws IOException {
        InputStream inputStream = this.wrappedStream;
        if (inputStream != null) {
            try {
                boolean bl2 = true;
                if (this.eofWatcher != null) {
                    bl2 = this.eofWatcher.streamAbort(inputStream);
                }
                if (bl2) {
                    inputStream.close();
                }
                return;
            }
            finally {
                this.wrappedStream = null;
            }
        }
    }

    public void abort() throws IOException {
        this.selfClosed = true;
        this.checkAbort();
    }
}

