/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.io.entity;

import java.io.IOException;
import java.io.InputStream;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.io.entity.AbstractHttpEntity;
import org.apache.hc.core5.io.Closer;
import org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class BasicHttpEntity
extends AbstractHttpEntity {
    private final InputStream content;
    private final long length;

    public BasicHttpEntity(InputStream inputStream, long l2, ContentType contentType, String string, boolean bl2) {
        super(contentType, string, bl2);
        this.content = Args.notNull(inputStream, "Content stream");
        this.length = l2;
    }

    public BasicHttpEntity(InputStream inputStream, long l2, ContentType contentType, String string) {
        this(inputStream, l2, contentType, string, false);
    }

    public BasicHttpEntity(InputStream inputStream, long l2, ContentType contentType) {
        this(inputStream, l2, contentType, null);
    }

    public BasicHttpEntity(InputStream inputStream, ContentType contentType, String string) {
        this(inputStream, -1L, contentType, string);
    }

    public BasicHttpEntity(InputStream inputStream, ContentType contentType) {
        this(inputStream, -1L, contentType, null);
    }

    public BasicHttpEntity(InputStream inputStream, ContentType contentType, boolean bl2) {
        this(inputStream, -1L, contentType, null, bl2);
    }

    @Override
    public final long getContentLength() {
        return this.length;
    }

    @Override
    public final InputStream getContent() throws IllegalStateException {
        return this.content;
    }

    @Override
    public final boolean isRepeatable() {
        return false;
    }

    @Override
    public final boolean isStreaming() {
        return true;
    }

    @Override
    public final void close() throws IOException {
        Closer.close(this.content);
    }
}

