/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.io.entity;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.io.entity.AbstractHttpEntity;
import org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class ByteArrayEntity
extends AbstractHttpEntity {
    private final byte[] buf;
    private final int off;
    private final int len;

    public ByteArrayEntity(byte[] byArray, int n2, int n3, ContentType contentType, String string, boolean bl2) {
        super(contentType, string, bl2);
        Args.notNull(byArray, "Source byte array");
        Args.notNegative(n2, "offset");
        Args.notNegative(n3, "length");
        Args.notNegative(n2 + n3, "off + len");
        Args.check(n2 <= byArray.length, "off %s cannot be greater then b.length %s ", n2, byArray.length);
        Args.check(n2 + n3 <= byArray.length, "off + len  %s cannot be less then b.length %s ", n2 + n3, byArray.length);
        this.buf = byArray;
        this.off = n2;
        this.len = n3;
    }

    public ByteArrayEntity(byte[] byArray, int n2, int n3, ContentType contentType, String string) {
        this(byArray, n2, n3, contentType, string, false);
    }

    public ByteArrayEntity(byte[] byArray, ContentType contentType, String string, boolean bl2) {
        super(contentType, string, bl2);
        Args.notNull(byArray, "Source byte array");
        this.buf = byArray;
        this.off = 0;
        this.len = this.buf.length;
    }

    public ByteArrayEntity(byte[] byArray, ContentType contentType, String string) {
        this(byArray, contentType, string, false);
    }

    public ByteArrayEntity(byte[] byArray, ContentType contentType, boolean bl2) {
        this(byArray, contentType, null, bl2);
    }

    public ByteArrayEntity(byte[] byArray, ContentType contentType) {
        this(byArray, contentType, null, false);
    }

    public ByteArrayEntity(byte[] byArray, int n2, int n3, ContentType contentType, boolean bl2) {
        this(byArray, n2, n3, contentType, null, bl2);
    }

    public ByteArrayEntity(byte[] byArray, int n2, int n3, ContentType contentType) {
        this(byArray, n2, n3, contentType, null, false);
    }

    @Override
    public final boolean isRepeatable() {
        return true;
    }

    @Override
    public final long getContentLength() {
        return this.len;
    }

    @Override
    public final InputStream getContent() {
        return new ByteArrayInputStream(this.buf, this.off, this.len);
    }

    @Override
    public final void writeTo(OutputStream outputStream) throws IOException {
        Args.notNull(outputStream, "Output stream");
        outputStream.write(this.buf, this.off, this.len);
        outputStream.flush();
    }

    @Override
    public final boolean isStreaming() {
        return false;
    }

    @Override
    public final void close() throws IOException {
    }
}

