/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.io.entity;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.io.entity.AbstractHttpEntity;
import org.apache.hc.core5.io.IOCallback;
import org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public final class EntityTemplate
extends AbstractHttpEntity {
    private final long contentLength;
    private final IOCallback<OutputStream> callback;

    public EntityTemplate(long l2, ContentType contentType, String string, IOCallback<OutputStream> iOCallback) {
        super(contentType, string);
        this.contentLength = l2;
        this.callback = Args.notNull(iOCallback, "I/O callback");
    }

    @Override
    public final long getContentLength() {
        return this.contentLength;
    }

    @Override
    public final InputStream getContent() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ((AbstractHttpEntity)this).writeTo(byteArrayOutputStream);
        return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
    }

    @Override
    public final boolean isRepeatable() {
        return true;
    }

    @Override
    public final void writeTo(OutputStream outputStream) throws IOException {
        Args.notNull(outputStream, "Output stream");
        this.callback.execute(outputStream);
    }

    @Override
    public final boolean isStreaming() {
        return false;
    }

    @Override
    public final void close() throws IOException {
    }
}

