/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.io.entity;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.io.entity.AbstractHttpEntity;
import org.apache.hc.core5.util.Args;

public class InputStreamEntity
extends AbstractHttpEntity {
    private final InputStream content;
    private final long length;

    public InputStreamEntity(InputStream inputStream, long l2, ContentType contentType, String string) {
        super(contentType, string);
        this.content = Args.notNull(inputStream, "Source input stream");
        this.length = l2;
    }

    public InputStreamEntity(InputStream inputStream, long l2, ContentType contentType) {
        this(inputStream, l2, contentType, null);
    }

    public InputStreamEntity(InputStream inputStream, ContentType contentType) {
        this(inputStream, -1L, contentType, null);
    }

    @Override
    public final boolean isRepeatable() {
        return false;
    }

    @Override
    public final long getContentLength() {
        return this.length;
    }

    @Override
    public final InputStream getContent() throws IOException {
        return this.content;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final void writeTo(OutputStream outputStream) throws IOException {
        Args.notNull(outputStream, "Output stream");
        InputStream inputStream = this.content;
        Throwable throwable = null;
        try {
            byte[] byArray = new byte[4096];
            if (this.length < 0L) {
                int n2;
                while ((n2 = inputStream.read(byArray)) != -1) {
                    outputStream.write(byArray, 0, n2);
                }
            } else {
                int n3;
                for (long i2 = this.length; i2 > 0L && (n3 = inputStream.read(byArray, 0, (int)Math.min(4096L, i2))) != -1; i2 -= (long)n3) {
                    outputStream.write(byArray, 0, n3);
                }
            }
            if (inputStream == null) return;
        }
        catch (Throwable throwable2) {
            try {
                Throwable throwable3 = throwable2;
                throwable = throwable2;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                if (inputStream == null) throw throwable4;
                if (throwable != null) {
                    try {
                        inputStream.close();
                        throw throwable4;
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                    throw throwable4;
                } else {
                    inputStream.close();
                }
                throw throwable4;
            }
        }
        inputStream.close();
        return;
    }

    @Override
    public final boolean isStreaming() {
        return true;
    }

    @Override
    public final void close() throws IOException {
        this.content.close();
    }
}

