/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.io.entity;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.io.entity.AbstractHttpEntity;
import org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class StringEntity
extends AbstractHttpEntity {
    private final byte[] content;

    public StringEntity(String string, ContentType object, String string2, boolean bl2) {
        super((ContentType)object, string2, bl2);
        Args.notNull(string, "Source string");
        object = ContentType.getCharset((ContentType)object, StandardCharsets.UTF_8);
        this.content = string.getBytes((Charset)object);
    }

    public StringEntity(String string, ContentType contentType, boolean bl2) {
        this(string, contentType, null, bl2);
    }

    public StringEntity(String string, ContentType contentType) {
        this(string, contentType, null, false);
    }

    public StringEntity(String string, Charset charset) {
        this(string, ContentType.TEXT_PLAIN.withCharset(charset));
    }

    public StringEntity(String string, Charset charset, boolean bl2) {
        this(string, ContentType.TEXT_PLAIN.withCharset(charset), bl2);
    }

    public StringEntity(String string) {
        this(string, ContentType.DEFAULT_TEXT);
    }

    @Override
    public final boolean isRepeatable() {
        return true;
    }

    @Override
    public final long getContentLength() {
        return this.content.length;
    }

    @Override
    public final InputStream getContent() throws IOException {
        return new ByteArrayInputStream(this.content);
    }

    @Override
    public final void writeTo(OutputStream outputStream) throws IOException {
        Args.notNull(outputStream, "Output stream");
        outputStream.write(this.content);
        outputStream.flush();
    }

    @Override
    public final boolean isStreaming() {
        return false;
    }

    @Override
    public final void close() throws IOException {
    }
}

