/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.io.support;

import java.io.IOException;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.io.HttpFilterChain;
import org.apache.hc.core5.http.io.HttpFilterChain$ResponseTrigger;
import org.apache.hc.core5.http.io.HttpFilterHandler;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.message.BasicClassicHttpResponse;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.net.URIAuthority;

@Contract(threading=ThreadingBehavior.STATELESS)
public abstract class AbstractHttpServerAuthFilter<T>
implements HttpFilterHandler {
    private final boolean respondImmediately;

    protected AbstractHttpServerAuthFilter(boolean bl2) {
        this.respondImmediately = bl2;
    }

    protected abstract T parseChallengeResponse(String var1, HttpContext var2) throws HttpException;

    protected abstract boolean authenticate(T var1, URIAuthority var2, String var3, HttpContext var4);

    protected abstract String generateChallenge(T var1, URIAuthority var2, String var3, HttpContext var4);

    protected HttpEntity generateResponseContent(HttpResponse httpResponse) {
        return new StringEntity("Unauthorized");
    }

    @Override
    public final void handle(ClassicHttpRequest classicHttpRequest, HttpFilterChain$ResponseTrigger httpFilterChain$ResponseTrigger, HttpContext object, HttpFilterChain object2) throws HttpException, IOException {
        boolean bl2;
        Header header = classicHttpRequest.getFirstHeader("Authorization");
        header = header != null ? this.parseChallengeResponse(header.getValue(), (HttpContext)object) : null;
        URIAuthority uRIAuthority = classicHttpRequest.getAuthority();
        String string = classicHttpRequest.getRequestUri();
        boolean bl3 = this.authenticate(header, uRIAuthority, string, (HttpContext)object);
        Header header2 = classicHttpRequest.getFirstHeader("Expect");
        boolean bl4 = bl2 = header2 != null && "100-continue".equalsIgnoreCase(header2.getValue());
        if (bl3) {
            if (bl2) {
                httpFilterChain$ResponseTrigger.sendInformation(new BasicClassicHttpResponse(100));
            }
            object2.proceed(classicHttpRequest, httpFilterChain$ResponseTrigger, (HttpContext)object);
            return;
        }
        object2 = new BasicClassicHttpResponse(401);
        object2.addHeader("WWW-Authenticate", this.generateChallenge(header, uRIAuthority, string, (HttpContext)object));
        object = this.generateResponseContent((HttpResponse)object2);
        object2.setEntity((HttpEntity)object);
        if (this.respondImmediately || bl2 || classicHttpRequest.getEntity() == null) {
            httpFilterChain$ResponseTrigger.submitResponse((ClassicHttpResponse)object2);
            EntityUtils.consume(classicHttpRequest.getEntity());
            return;
        }
        EntityUtils.consume(classicHttpRequest.getEntity());
        httpFilterChain$ResponseTrigger.submitResponse((ClassicHttpResponse)object2);
    }
}

