/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.message;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.hc.core5.http.FormattedHeader;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.message.ParserCursor;
import org.apache.hc.core5.util.Args;

abstract class AbstractHeaderElementIterator<T>
implements Iterator<T> {
    private final Iterator<? extends Header> headerIt;
    private T currentElement;
    private CharSequence buffer;
    private ParserCursor cursor;

    AbstractHeaderElementIterator(Iterator<? extends Header> iterator) {
        this.headerIt = Args.notNull(iterator, "Header iterator");
    }

    private void bufferHeaderValue() {
        this.cursor = null;
        this.buffer = null;
        while (this.headerIt.hasNext()) {
            Object object = this.headerIt.next();
            if (object instanceof FormattedHeader) {
                this.buffer = ((FormattedHeader)object).getBuffer();
                this.cursor = new ParserCursor(0, this.buffer.length());
                this.cursor.updatePos(((FormattedHeader)object).getValuePos());
                return;
            }
            if ((object = object.getValue()) == null) continue;
            this.buffer = object;
            this.cursor = new ParserCursor(0, ((String)object).length());
            return;
        }
    }

    abstract T parseHeaderElement(CharSequence var1, ParserCursor var2);

    private void parseNextElement() {
        while (this.headerIt.hasNext() || this.cursor != null) {
            if (this.cursor == null || this.cursor.atEnd()) {
                this.bufferHeaderValue();
            }
            if (this.cursor == null) continue;
            while (!this.cursor.atEnd()) {
                AbstractHeaderElementIterator abstractHeaderElementIterator = this;
                T t2 = abstractHeaderElementIterator.parseHeaderElement(abstractHeaderElementIterator.buffer, this.cursor);
                if (t2 == null) continue;
                this.currentElement = t2;
                return;
            }
            if (!this.cursor.atEnd()) continue;
            this.cursor = null;
            this.buffer = null;
        }
    }

    @Override
    public boolean hasNext() {
        if (this.currentElement == null) {
            this.parseNextElement();
        }
        return this.currentElement != null;
    }

    @Override
    public T next() throws NoSuchElementException {
        if (this.currentElement == null) {
            this.parseNextElement();
        }
        if (this.currentElement == null) {
            throw new NoSuchElementException("No more header elements available");
        }
        T t2 = this.currentElement;
        this.currentElement = null;
        return t2;
    }

    @Override
    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Remove not supported");
    }
}

