/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.message;

import java.io.Serializable;
import java.util.Objects;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class BasicHeader
implements Serializable,
Cloneable,
Header {
    private static final long serialVersionUID = -5427236326487562174L;
    private final String name;
    private final boolean sensitive;
    private final String value;

    public BasicHeader(String string, Object object) {
        this(string, object, false);
    }

    public BasicHeader(String string, Object object, boolean bl2) {
        this.name = Args.notNull(string, "Name");
        this.value = Objects.toString(object, null);
        this.sensitive = bl2;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public boolean isSensitive() {
        return this.sensitive;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getName()).append(": ");
        if (this.getValue() != null) {
            stringBuilder.append(this.getValue());
        }
        return stringBuilder.toString();
    }

    public BasicHeader clone() throws CloneNotSupportedException {
        return (BasicHeader)super.clone();
    }
}

