/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.message;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.Method;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.URIScheme;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.message.HeaderGroup;
import org.apache.hc.core5.net.URIAuthority;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.TextUtils;

public class BasicHttpRequest
extends HeaderGroup
implements HttpRequest {
    private static final long serialVersionUID = 1L;
    private final String method;
    private String path;
    private String scheme;
    private URIAuthority authority;
    private ProtocolVersion version;
    private URI requestUri;
    private boolean absoluteRequestUri;

    public BasicHttpRequest(String string, String string2, URIAuthority uRIAuthority, String string3) {
        this.method = Args.notNull(string, "Method name");
        this.scheme = string2;
        this.authority = uRIAuthority;
        this.path = string3;
    }

    public BasicHttpRequest(String string, String string2) {
        this.method = string;
        if (string2 != null) {
            try {
                this.setUri(new URI(string2));
                return;
            }
            catch (URISyntaxException uRISyntaxException) {
                this.path = string2;
            }
        }
    }

    public BasicHttpRequest(String string, HttpHost httpHost, String string2) {
        this.method = Args.notNull(string, "Method name");
        this.scheme = httpHost != null ? httpHost.getSchemeName() : null;
        this.authority = httpHost != null ? new URIAuthority(httpHost) : null;
        this.path = string2;
    }

    public BasicHttpRequest(String string, URI uRI) {
        this.method = Args.notNull(string, "Method name");
        this.setUri(Args.notNull(uRI, "Request URI"));
    }

    public BasicHttpRequest(Method method, String string) {
        this.method = Args.notNull(method, "Method").name();
        if (string != null) {
            try {
                this.setUri(new URI(string));
                return;
            }
            catch (URISyntaxException uRISyntaxException) {
                this.path = string;
            }
        }
    }

    public BasicHttpRequest(Method method, HttpHost httpHost, String string) {
        this.method = Args.notNull(method, "Method").name();
        this.scheme = httpHost != null ? httpHost.getSchemeName() : null;
        this.authority = httpHost != null ? new URIAuthority(httpHost) : null;
        this.path = string;
    }

    public BasicHttpRequest(Method method, URI uRI) {
        this.method = Args.notNull(method, "Method").name();
        this.setUri(Args.notNull(uRI, "Request URI"));
    }

    @Override
    public void addHeader(String string, Object object) {
        Args.notNull(string, "Header name");
        this.addHeader(new BasicHeader(string, object));
    }

    @Override
    public void setHeader(String string, Object object) {
        Args.notNull(string, "Header name");
        this.setHeader(new BasicHeader(string, object));
    }

    @Override
    public void setVersion(ProtocolVersion protocolVersion) {
        this.version = protocolVersion;
    }

    @Override
    public ProtocolVersion getVersion() {
        return this.version;
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public void setPath(String string) {
        this.path = string;
        this.requestUri = null;
    }

    @Override
    public String getScheme() {
        return this.scheme;
    }

    @Override
    public void setScheme(String string) {
        this.scheme = string;
        this.requestUri = null;
    }

    @Override
    public URIAuthority getAuthority() {
        return this.authority;
    }

    @Override
    public void setAuthority(URIAuthority uRIAuthority) {
        this.authority = uRIAuthority;
        this.requestUri = null;
    }

    public void setAbsoluteRequestUri(boolean bl2) {
        this.absoluteRequestUri = bl2;
    }

    @Override
    public String getRequestUri() {
        if (this.absoluteRequestUri) {
            StringBuilder stringBuilder = new StringBuilder();
            this.assembleRequestUri(stringBuilder);
            return stringBuilder.toString();
        }
        return this.getPath();
    }

    @Override
    public void setUri(URI object) {
        this.scheme = ((URI)object).getScheme();
        if (((URI)object).getHost() != null) {
            this.authority = new URIAuthority(((URI)object).getRawUserInfo(), ((URI)object).getHost(), ((URI)object).getPort());
        } else {
            if (((URI)object).getRawAuthority() != null) {
                try {
                    this.authority = URIAuthority.create(((URI)object).getRawAuthority());
                }
                catch (URISyntaxException uRISyntaxException) {}
            }
            this.authority = null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string = ((URI)object).getRawPath();
        if (!TextUtils.isBlank(string)) {
            stringBuilder.append(string);
        } else {
            stringBuilder.append("/");
        }
        object = ((URI)object).getRawQuery();
        if (object != null) {
            stringBuilder.append('?').append((String)object);
        }
        this.path = stringBuilder.toString();
        this.requestUri = null;
    }

    private void assembleRequestUri(StringBuilder stringBuilder) {
        if (this.authority != null) {
            stringBuilder.append(this.scheme != null ? this.scheme : URIScheme.HTTP.id).append("://");
            stringBuilder.append(this.authority.getHostName());
            if (this.authority.getPort() >= 0) {
                stringBuilder.append(":").append(this.authority.getPort());
            }
        }
        if (this.path == null) {
            stringBuilder.append("/");
            return;
        }
        if (stringBuilder.length() > 0 && !this.path.startsWith("/")) {
            stringBuilder.append("/");
        }
        stringBuilder.append(this.path);
    }

    @Override
    public URI getUri() throws URISyntaxException {
        if (this.requestUri == null) {
            StringBuilder stringBuilder = new StringBuilder();
            this.assembleRequestUri(stringBuilder);
            this.requestUri = new URI(stringBuilder.toString());
        }
        return this.requestUri;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.method).append(" ");
        this.assembleRequestUri(stringBuilder);
        return stringBuilder.toString();
    }
}

