/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.message;

import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.message.LineFormatter;
import org.apache.hc.core5.http.message.RequestLine;
import org.apache.hc.core5.http.message.StatusLine;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.CharArrayBuffer;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class BasicLineFormatter
implements LineFormatter {
    public static final BasicLineFormatter INSTANCE = new BasicLineFormatter();

    void formatProtocolVersion(CharArrayBuffer charArrayBuffer, ProtocolVersion protocolVersion) {
        charArrayBuffer.append(protocolVersion.format());
    }

    @Override
    public void formatRequestLine(CharArrayBuffer charArrayBuffer, RequestLine requestLine) {
        Args.notNull(charArrayBuffer, "Char array buffer");
        Args.notNull(requestLine, "Request line");
        charArrayBuffer.append(requestLine.getMethod());
        charArrayBuffer.append(' ');
        charArrayBuffer.append(requestLine.getUri());
        charArrayBuffer.append(' ');
        this.formatProtocolVersion(charArrayBuffer, requestLine.getProtocolVersion());
    }

    @Override
    public void formatStatusLine(CharArrayBuffer charArrayBuffer, StatusLine object) {
        Args.notNull(charArrayBuffer, "Char array buffer");
        Args.notNull(object, "Status line");
        this.formatProtocolVersion(charArrayBuffer, ((StatusLine)object).getProtocolVersion());
        charArrayBuffer.append(' ');
        charArrayBuffer.append(Integer.toString(((StatusLine)object).getStatusCode()));
        charArrayBuffer.append(' ');
        object = ((StatusLine)object).getReasonPhrase();
        if (object != null) {
            charArrayBuffer.append((String)object);
        }
    }

    @Override
    public void formatHeader(CharArrayBuffer charArrayBuffer, Header object) {
        Args.notNull(charArrayBuffer, "Char array buffer");
        Args.notNull(object, "Header");
        charArrayBuffer.append(object.getName());
        charArrayBuffer.append(": ");
        object = object.getValue();
        if (object != null) {
            CharArrayBuffer charArrayBuffer2 = charArrayBuffer;
            charArrayBuffer2.ensureCapacity(charArrayBuffer2.length() + ((String)object).length());
            for (int i2 = 0; i2 < ((String)object).length(); ++i2) {
                char c2 = ((String)object).charAt(i2);
                if (c2 == '\r' || c2 == '\n' || c2 == '\f' || c2 == '\u000b') {
                    c2 = ' ';
                }
                charArrayBuffer.append(c2);
            }
        }
    }
}

