/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.message;

import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.ProtocolVersionParser;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.message.LineParser;
import org.apache.hc.core5.http.message.ParserCursor;
import org.apache.hc.core5.http.message.RequestLine;
import org.apache.hc.core5.http.message.StatusLine;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.CharArrayBuffer;
import org.apache.hc.core5.util.TextUtils;
import org.apache.hc.core5.util.Tokenizer;
import org.apache.hc.core5.util.Tokenizer$Cursor;
import org.apache.hc.core5.util.Tokenizer$Delimiter;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class BasicLineParser
implements LineParser {
    public static final BasicLineParser INSTANCE = new BasicLineParser();
    private static final Tokenizer$Delimiter BLANKS = Tokenizer.delimiters(' ', '\t');
    private static final Tokenizer$Delimiter COLON = Tokenizer.delimiters(':');
    private final ProtocolVersion protocol;
    private final Tokenizer tokenizer;

    public BasicLineParser(ProtocolVersion protocolVersion) {
        this.protocol = protocolVersion != null ? protocolVersion : HttpVersion.HTTP_1_1;
        this.tokenizer = Tokenizer.INSTANCE;
    }

    public BasicLineParser() {
        this(null);
    }

    ProtocolVersion parseProtocolVersion(CharArrayBuffer charArrayBuffer, ParserCursor parserCursor) throws ParseException {
        String string = this.protocol.getProtocol();
        int n2 = string.length();
        this.tokenizer.skipWhiteSpace(charArrayBuffer, parserCursor);
        int n3 = parserCursor.getPos();
        if (n3 + n2 + 4 > parserCursor.getUpperBound()) {
            throw new ParseException("Invalid protocol version", charArrayBuffer, parserCursor.getLowerBound(), parserCursor.getUpperBound(), parserCursor.getPos());
        }
        boolean bl2 = true;
        for (int i2 = 0; bl2 && i2 < n2; ++i2) {
            bl2 = charArrayBuffer.charAt(n3 + i2) == string.charAt(i2);
        }
        if (bl2) {
            boolean bl3 = bl2 = charArrayBuffer.charAt(n3 + n2) == '/';
        }
        if (!bl2) {
            throw new ParseException("Invalid protocol version", charArrayBuffer, parserCursor.getLowerBound(), parserCursor.getUpperBound(), parserCursor.getPos());
        }
        parserCursor.updatePos(n3 + n2 + 1);
        return ProtocolVersionParser.INSTANCE.parse(string, HttpVersion::get, charArrayBuffer, parserCursor, null);
    }

    @Override
    public RequestLine parseRequestLine(CharArrayBuffer charArrayBuffer) throws ParseException {
        Args.notNull(charArrayBuffer, "Char array buffer");
        ParserCursor parserCursor = new ParserCursor(0, charArrayBuffer.length());
        this.tokenizer.skipWhiteSpace(charArrayBuffer, parserCursor);
        String string = this.tokenizer.parseToken((CharSequence)charArrayBuffer, (Tokenizer$Cursor)parserCursor, BLANKS);
        if (TextUtils.isEmpty(string)) {
            throw new ParseException("Invalid request line", charArrayBuffer, parserCursor.getLowerBound(), parserCursor.getUpperBound(), parserCursor.getPos());
        }
        this.tokenizer.skipWhiteSpace(charArrayBuffer, parserCursor);
        String string2 = this.tokenizer.parseToken((CharSequence)charArrayBuffer, (Tokenizer$Cursor)parserCursor, BLANKS);
        if (TextUtils.isEmpty(string2)) {
            throw new ParseException("Invalid request line", charArrayBuffer, parserCursor.getLowerBound(), parserCursor.getUpperBound(), parserCursor.getPos());
        }
        ProtocolVersion protocolVersion = this.parseProtocolVersion(charArrayBuffer, parserCursor);
        this.tokenizer.skipWhiteSpace(charArrayBuffer, parserCursor);
        if (!parserCursor.atEnd()) {
            throw new ParseException("Invalid request line", charArrayBuffer, parserCursor.getLowerBound(), parserCursor.getUpperBound(), parserCursor.getPos());
        }
        return new RequestLine(string, string2, protocolVersion);
    }

    @Override
    public StatusLine parseStatusLine(CharArrayBuffer charArrayBuffer) throws ParseException {
        int n2;
        Args.notNull(charArrayBuffer, "Char array buffer");
        ParserCursor parserCursor = new ParserCursor(0, charArrayBuffer.length());
        this.tokenizer.skipWhiteSpace(charArrayBuffer, parserCursor);
        ProtocolVersion protocolVersion = this.parseProtocolVersion(charArrayBuffer, parserCursor);
        this.tokenizer.skipWhiteSpace(charArrayBuffer, parserCursor);
        int n3 = 0;
        for (n2 = 1; n2 <= 3; ++n2) {
            if (parserCursor.atEnd()) {
                throw new ParseException("Status line contains invalid status code", charArrayBuffer, parserCursor.getLowerBound(), parserCursor.getUpperBound(), parserCursor.getPos());
            }
            char c2 = charArrayBuffer.charAt(parserCursor.getPos());
            if (c2 < '0' || c2 > '9') {
                throw new ParseException("Status line contains invalid status code", charArrayBuffer, parserCursor.getLowerBound(), parserCursor.getUpperBound(), parserCursor.getPos());
            }
            n3 = n3 * 10 + (c2 - 48);
            ParserCursor parserCursor2 = parserCursor;
            parserCursor2.updatePos(parserCursor2.getPos() + 1);
        }
        if (!parserCursor.atEnd()) {
            char c3 = charArrayBuffer.charAt(parserCursor.getPos());
            n2 = c3;
            if (Tokenizer.isWhitespace(c3)) {
                ParserCursor parserCursor3 = parserCursor;
                parserCursor3.updatePos(parserCursor3.getPos() + 1);
            } else {
                throw new ParseException("Status line contains invalid status code", charArrayBuffer, parserCursor.getLowerBound(), parserCursor.getUpperBound(), parserCursor.getPos());
            }
        }
        this.tokenizer.skipWhiteSpace(charArrayBuffer, parserCursor);
        String string = charArrayBuffer.substringTrimmed(parserCursor.getPos(), parserCursor.getUpperBound());
        return new StatusLine(protocolVersion, n3, string);
    }

    @Override
    public Header parseHeader(CharArrayBuffer charSequence) throws ParseException {
        Args.notNull(charSequence, "Char array buffer");
        ParserCursor parserCursor = new ParserCursor(0, charSequence.length());
        this.tokenizer.skipWhiteSpace(charSequence, parserCursor);
        String string = this.tokenizer.parseToken(charSequence, (Tokenizer$Cursor)parserCursor, COLON);
        if (parserCursor.getPos() == parserCursor.getLowerBound() || parserCursor.getPos() == parserCursor.getUpperBound() || charSequence.charAt(parserCursor.getPos()) != ':' || TextUtils.isEmpty(string) || Tokenizer.isWhitespace(charSequence.charAt(parserCursor.getPos() - 1))) {
            throw new ParseException("Invalid header", charSequence, parserCursor.getLowerBound(), parserCursor.getUpperBound(), parserCursor.getPos());
        }
        charSequence = charSequence.substringTrimmed(parserCursor.getPos() + 1, parserCursor.getUpperBound());
        return new BasicHeader(string, charSequence);
    }
}

