/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.message;

import java.io.Serializable;
import java.util.Objects;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.LangUtils;
import org.apache.hc.core5.util.TextUtils;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class BasicNameValuePair
implements Serializable,
NameValuePair {
    private static final long serialVersionUID = -6437800749411518984L;
    private final String name;
    private final String value;

    public BasicNameValuePair(String string, String string2) {
        this.name = Args.notNull(string, "Name");
        this.value = string2;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public String toString() {
        if (this.value == null) {
            return this.name;
        }
        int n2 = this.name.length() + 1 + this.value.length();
        StringBuilder stringBuilder = new StringBuilder(n2);
        stringBuilder.append(this.name);
        stringBuilder.append("=");
        stringBuilder.append(this.value);
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof BasicNameValuePair) {
            object = (BasicNameValuePair)object;
            return this.name.equalsIgnoreCase(((BasicNameValuePair)object).name) && Objects.equals(this.value, ((BasicNameValuePair)object).value);
        }
        return false;
    }

    public int hashCode() {
        int n2 = LangUtils.hashCode(17, TextUtils.toLowerCase(this.name));
        n2 = LangUtils.hashCode(n2, this.value);
        return n2;
    }
}

