/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.message;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.MessageHeaders;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.message.BasicListHeaderIterator;
import org.apache.hc.core5.util.CharArrayBuffer;
import org.apache.hc.core5.util.TextUtils;

public class HeaderGroup
implements Serializable,
MessageHeaders {
    private static final long serialVersionUID = 2608834160639271617L;
    private static final Header[] EMPTY = new Header[0];
    private final List<Header> headers = new ArrayList<Header>(16);

    public void clear() {
        this.headers.clear();
    }

    public void addHeader(Header header) {
        if (header == null) {
            return;
        }
        this.headers.add(header);
    }

    public boolean removeHeader(Header header) {
        if (header == null) {
            return false;
        }
        for (int i2 = 0; i2 < this.headers.size(); ++i2) {
            Header header2 = this.headers.get(i2);
            if (!this.headerEquals(header, header2)) continue;
            this.headers.remove(header2);
            return true;
        }
        return false;
    }

    private boolean headerEquals(Header header, Header header2) {
        return header2 == header || header2.getName().equalsIgnoreCase(header.getName()) && Objects.equals(header.getValue(), header2.getValue());
    }

    public boolean removeHeaders(Header header) {
        if (header == null) {
            return false;
        }
        boolean bl2 = false;
        Iterator<Header> iterator = this.headerIterator();
        while (iterator.hasNext()) {
            Header header2 = iterator.next();
            if (!this.headerEquals(header, header2)) continue;
            iterator.remove();
            bl2 = true;
        }
        return bl2;
    }

    public void setHeader(Header header) {
        if (header == null) {
            return;
        }
        for (int i2 = 0; i2 < this.headers.size(); ++i2) {
            Header header2 = this.headers.get(i2);
            if (!header2.getName().equalsIgnoreCase(header.getName())) continue;
            this.headers.set(i2, header);
            return;
        }
        this.headers.add(header);
    }

    public void setHeaders(Header ... headerArray) {
        this.clear();
        if (headerArray == null) {
            return;
        }
        Collections.addAll(this.headers, headerArray);
    }

    public Header getCondensedHeader(String string) {
        Header[] headerArray = this.getHeaders(string);
        if (headerArray.length == 0) {
            return null;
        }
        if (headerArray.length == 1) {
            return headerArray[0];
        }
        CharArrayBuffer charArrayBuffer = new CharArrayBuffer(128);
        charArrayBuffer.append(headerArray[0].getValue());
        for (int i2 = 1; i2 < headerArray.length; ++i2) {
            charArrayBuffer.append(", ");
            charArrayBuffer.append(headerArray[i2].getValue());
        }
        return new BasicHeader(TextUtils.toLowerCase(string), charArrayBuffer.toString());
    }

    @Override
    public Header[] getHeaders(String string) {
        ArrayList<Header> arrayList = null;
        for (int i2 = 0; i2 < this.headers.size(); ++i2) {
            Header header = this.headers.get(i2);
            if (!header.getName().equalsIgnoreCase(string)) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<Header>();
            }
            arrayList.add(header);
        }
        if (arrayList != null) {
            return arrayList.toArray(EMPTY);
        }
        return EMPTY;
    }

    @Override
    public Header getFirstHeader(String string) {
        for (int i2 = 0; i2 < this.headers.size(); ++i2) {
            Header header = this.headers.get(i2);
            if (!header.getName().equalsIgnoreCase(string)) continue;
            return header;
        }
        return null;
    }

    @Override
    public Header getHeader(String string) throws ProtocolException {
        int n2 = 0;
        Header header = null;
        for (int i2 = 0; i2 < this.headers.size(); ++i2) {
            Header header2 = this.headers.get(i2);
            if (!header2.getName().equalsIgnoreCase(string)) continue;
            header = header2;
            ++n2;
        }
        if (n2 > 1) {
            throw new ProtocolException("multiple '%s' headers found", string);
        }
        return header;
    }

    @Override
    public Header getLastHeader(String string) {
        for (int i2 = this.headers.size() - 1; i2 >= 0; --i2) {
            Header header = this.headers.get(i2);
            if (!header.getName().equalsIgnoreCase(string)) continue;
            return header;
        }
        return null;
    }

    @Override
    public Header[] getHeaders() {
        return this.headers.toArray(EMPTY);
    }

    @Override
    public boolean containsHeader(String string) {
        for (int i2 = 0; i2 < this.headers.size(); ++i2) {
            Header header = this.headers.get(i2);
            if (!header.getName().equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int countHeaders(String string) {
        int n2 = 0;
        for (int i2 = 0; i2 < this.headers.size(); ++i2) {
            Header header = this.headers.get(i2);
            if (!header.getName().equalsIgnoreCase(string)) continue;
            ++n2;
        }
        return n2;
    }

    @Override
    public Iterator<Header> headerIterator() {
        return new BasicListHeaderIterator(this.headers, null);
    }

    @Override
    public Iterator<Header> headerIterator(String string) {
        return new BasicListHeaderIterator(this.headers, string);
    }

    public boolean removeHeaders(String string) {
        if (string == null) {
            return false;
        }
        boolean bl2 = false;
        Iterator<Header> iterator = this.headerIterator();
        while (iterator.hasNext()) {
            Header header = iterator.next();
            if (!header.getName().equalsIgnoreCase(string)) continue;
            iterator.remove();
            bl2 = true;
        }
        return bl2;
    }

    public String toString() {
        return this.headers.toString();
    }
}

