/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.message;

import java.io.Serializable;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.message.StatusLine$StatusClass;
import org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public final class StatusLine
implements Serializable {
    private static final long serialVersionUID = -2443303766890459269L;
    private final ProtocolVersion protoVersion;
    private final int statusCode;
    private final StatusLine$StatusClass statusClass;
    private final String reasonPhrase;

    public StatusLine(HttpResponse httpResponse) {
        Args.notNull(httpResponse, "Response");
        this.protoVersion = httpResponse.getVersion() != null ? httpResponse.getVersion() : HttpVersion.HTTP_1_1;
        this.statusCode = httpResponse.getCode();
        this.statusClass = StatusLine$StatusClass.from(this.statusCode);
        this.reasonPhrase = httpResponse.getReasonPhrase();
    }

    public StatusLine(ProtocolVersion protocolVersion, int n2, String string) {
        this.statusCode = Args.notNegative(n2, "Status code");
        this.statusClass = StatusLine$StatusClass.from(this.statusCode);
        this.protoVersion = protocolVersion != null ? protocolVersion : HttpVersion.HTTP_1_1;
        this.reasonPhrase = string;
    }

    public final int getStatusCode() {
        return this.statusCode;
    }

    public final StatusLine$StatusClass getStatusClass() {
        return this.statusClass;
    }

    public final boolean isInformational() {
        return this.getStatusClass() == StatusLine$StatusClass.INFORMATIONAL;
    }

    public final boolean isSuccessful() {
        return this.getStatusClass() == StatusLine$StatusClass.SUCCESSFUL;
    }

    public final boolean isRedirection() {
        return this.getStatusClass() == StatusLine$StatusClass.REDIRECTION;
    }

    public final boolean isClientError() {
        return this.getStatusClass() == StatusLine$StatusClass.CLIENT_ERROR;
    }

    public final boolean isServerError() {
        return this.getStatusClass() == StatusLine$StatusClass.SERVER_ERROR;
    }

    public final boolean isError() {
        return this.isClientError() || this.isServerError();
    }

    public final ProtocolVersion getProtocolVersion() {
        return this.protoVersion;
    }

    public final String getReasonPhrase() {
        return this.reasonPhrase;
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.protoVersion).append(" ").append(this.statusCode).append(" ");
        if (this.reasonPhrase != null) {
            stringBuilder.append(this.reasonPhrase);
        }
        return stringBuilder.toString();
    }
}

