/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.nio.command;

import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.http.RequestNotExecutedException;
import org.apache.hc.core5.http.nio.command.ExecutableCommand;
import org.apache.hc.core5.reactor.Command;
import org.apache.hc.core5.reactor.IOSession;
import org.apache.hc.core5.util.Args;

@Internal
public final class CommandSupport {
    public static void failCommands(IOSession iOSession, Exception exception) {
        Command command;
        Args.notNull(iOSession, "I/O session");
        while ((command = iOSession.poll()) != null) {
            if (command instanceof ExecutableCommand) {
                ((ExecutableCommand)command).failed(exception);
                continue;
            }
            command.cancel();
        }
    }

    public static void cancelCommands(IOSession iOSession) {
        Command command;
        Args.notNull(iOSession, "I/O session");
        while ((command = iOSession.poll()) != null) {
            if (command instanceof ExecutableCommand) {
                if (!iOSession.isOpen()) {
                    ((ExecutableCommand)command).failed(new RequestNotExecutedException());
                    continue;
                }
                command.cancel();
                continue;
            }
            command.cancel();
        }
    }
}

