/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.nio.command;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.concurrent.CancellableDependency;
import org.apache.hc.core5.http.RequestNotExecutedException;
import org.apache.hc.core5.http.nio.AsyncClientExchangeHandler;
import org.apache.hc.core5.http.nio.AsyncPushConsumer;
import org.apache.hc.core5.http.nio.HandlerFactory;
import org.apache.hc.core5.http.nio.command.ExecutableCommand;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.Args;

@Internal
public final class RequestExecutionCommand
extends ExecutableCommand {
    private final AsyncClientExchangeHandler exchangeHandler;
    private final HandlerFactory<AsyncPushConsumer> pushHandlerFactory;
    private final CancellableDependency cancellableDependency;
    private final HttpContext context;
    private final AtomicBoolean failed;

    public RequestExecutionCommand(AsyncClientExchangeHandler asyncClientExchangeHandler, HandlerFactory<AsyncPushConsumer> handlerFactory, CancellableDependency cancellableDependency, HttpContext httpContext) {
        this.exchangeHandler = Args.notNull(asyncClientExchangeHandler, "Handler");
        this.pushHandlerFactory = handlerFactory;
        this.cancellableDependency = cancellableDependency;
        this.context = httpContext;
        this.failed = new AtomicBoolean();
    }

    public RequestExecutionCommand(AsyncClientExchangeHandler asyncClientExchangeHandler, HandlerFactory<AsyncPushConsumer> handlerFactory, HttpContext httpContext) {
        this(asyncClientExchangeHandler, handlerFactory, null, httpContext);
    }

    public RequestExecutionCommand(AsyncClientExchangeHandler asyncClientExchangeHandler, HttpContext httpContext) {
        this(asyncClientExchangeHandler, null, null, httpContext);
    }

    public final AsyncClientExchangeHandler getExchangeHandler() {
        return this.exchangeHandler;
    }

    public final HandlerFactory<AsyncPushConsumer> getPushHandlerFactory() {
        return this.pushHandlerFactory;
    }

    @Override
    public final CancellableDependency getCancellableDependency() {
        return this.cancellableDependency;
    }

    public final HttpContext getContext() {
        return this.context;
    }

    @Override
    public final void failed(Exception exception) {
        if (this.failed.compareAndSet(false, true)) {
            try {
                this.exchangeHandler.failed(exception);
                return;
            }
            finally {
                this.exchangeHandler.releaseResources();
            }
        }
    }

    @Override
    public final boolean cancel() {
        if (this.failed.compareAndSet(false, true)) {
            try {
                this.exchangeHandler.failed(new RequestNotExecutedException());
                return true;
            }
            finally {
                this.exchangeHandler.releaseResources();
            }
        }
        return false;
    }
}

