/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.nio.entity;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.config.CharCodingConfig;
import org.apache.hc.core5.http.nio.AsyncDataConsumer;
import org.apache.hc.core5.http.nio.CapacityChannel;
import org.apache.hc.core5.util.Args;

public abstract class AbstractCharDataConsumer
implements AsyncDataConsumer {
    protected static final int DEF_BUF_SIZE = 8192;
    private static final ByteBuffer EMPTY_BIN = ByteBuffer.wrap(new byte[0]);
    private final CharBuffer charBuffer;
    private final CharCodingConfig charCodingConfig;
    private volatile Charset charset;
    private volatile CharsetDecoder charsetDecoder;
    private volatile ByteBuffer byteBuffer;

    protected AbstractCharDataConsumer(int n2, CharCodingConfig charCodingConfig) {
        this.charBuffer = CharBuffer.allocate(Args.positive(n2, "Buffer size"));
        this.charCodingConfig = charCodingConfig != null ? charCodingConfig : CharCodingConfig.DEFAULT;
    }

    public AbstractCharDataConsumer() {
        this(8192, CharCodingConfig.DEFAULT);
    }

    protected abstract int capacityIncrement();

    protected abstract void data(CharBuffer var1, boolean var2) throws IOException;

    protected abstract void completed() throws IOException;

    protected final void setCharset(Charset charset) {
        this.charset = charset != null ? charset : this.charCodingConfig.getCharset();
        this.charsetDecoder = null;
    }

    @Override
    public final void updateCapacity(CapacityChannel capacityChannel) throws IOException {
        capacityChannel.update(this.capacityIncrement());
    }

    private void checkResult(CoderResult coderResult) throws IOException {
        if (coderResult.isError()) {
            coderResult.throwException();
        }
    }

    private void doDecode(boolean bl2) throws IOException {
        this.charBuffer.flip();
        AbstractCharDataConsumer abstractCharDataConsumer = this;
        abstractCharDataConsumer.data(abstractCharDataConsumer.charBuffer, bl2);
        this.charBuffer.clear();
    }

    private CharsetDecoder getCharsetDecoder() {
        Object object = this.charsetDecoder;
        if (object == null) {
            object = this.charset;
            if (object == null) {
                object = this.charCodingConfig.getCharset();
            }
            if (object == null) {
                object = StandardCharsets.UTF_8;
            }
            this.charsetDecoder = object = ((Charset)object).newDecoder();
            if (this.charCodingConfig.getMalformedInputAction() != null) {
                ((CharsetDecoder)object).onMalformedInput(this.charCodingConfig.getMalformedInputAction());
            }
            if (this.charCodingConfig.getUnmappableInputAction() != null) {
                ((CharsetDecoder)object).onUnmappableCharacter(this.charCodingConfig.getUnmappableInputAction());
            }
        }
        return object;
    }

    @Override
    public final void consume(ByteBuffer byteBuffer) throws IOException {
        CharsetDecoder charsetDecoder = this.getCharsetDecoder();
        while (byteBuffer.hasRemaining()) {
            ByteBuffer byteBuffer2 = this.byteBuffer;
            if (byteBuffer2 != null && byteBuffer2.position() > 0) {
                int n2 = byteBuffer2.remaining();
                if (n2 < byteBuffer.remaining()) {
                    int n3 = byteBuffer.limit();
                    ByteBuffer byteBuffer3 = byteBuffer;
                    byteBuffer3.limit(byteBuffer3.position() + n2);
                    byteBuffer2.put(byteBuffer);
                    byteBuffer.limit(n3);
                } else {
                    byteBuffer2.put(byteBuffer);
                }
                byteBuffer2.flip();
                CoderResult coderResult = charsetDecoder.decode(byteBuffer2, this.charBuffer, false);
                this.checkResult(coderResult);
                this.doDecode(false);
                byteBuffer2.compact();
            }
            if (byteBuffer2 != null && byteBuffer2.position() != 0) continue;
            CoderResult coderResult = charsetDecoder.decode(byteBuffer, this.charBuffer, false);
            this.checkResult(coderResult);
            this.doDecode(false);
            if (!coderResult.isUnderflow() || !byteBuffer.hasRemaining()) continue;
            if (byteBuffer2 == null) {
                this.byteBuffer = byteBuffer2 = ByteBuffer.allocate(Math.max(byteBuffer.remaining(), 1024));
            }
            byteBuffer2.put(byteBuffer);
        }
    }

    @Override
    public final void streamEnd(List<? extends Header> object) throws HttpException, IOException {
        object = this.getCharsetDecoder();
        this.checkResult(((CharsetDecoder)object).decode(EMPTY_BIN, this.charBuffer, true));
        this.doDecode(false);
        this.checkResult(((CharsetDecoder)object).flush(this.charBuffer));
        this.doDecode(true);
        this.completed();
    }
}

