/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.nio.entity;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.apache.hc.core5.function.Callback;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.nio.AsyncEntityProducer;
import org.apache.hc.core5.http.nio.StreamChannel;
import org.apache.hc.core5.http.nio.entity.AsyncEntityProducers$1;
import org.apache.hc.core5.http.nio.entity.AsyncEntityProducers$2;
import org.apache.hc.core5.http.nio.entity.AsyncEntityProducers$3;
import org.apache.hc.core5.http.nio.entity.BasicAsyncEntityProducer;
import org.apache.hc.core5.http.nio.entity.FileEntityProducer;
import org.apache.hc.core5.http.nio.entity.PathEntityProducer;
import org.apache.hc.core5.net.WWWFormCodec;

public final class AsyncEntityProducers {
    private AsyncEntityProducers() {
    }

    public static AsyncEntityProducer create(String string, ContentType contentType) {
        return new BasicAsyncEntityProducer(string, contentType);
    }

    public static AsyncEntityProducer create(String string, Charset charset) {
        return new BasicAsyncEntityProducer(string, ContentType.TEXT_PLAIN.withCharset(charset));
    }

    public static AsyncEntityProducer create(String string) {
        return new BasicAsyncEntityProducer(string, ContentType.TEXT_PLAIN);
    }

    public static AsyncEntityProducer create(byte[] byArray, ContentType contentType) {
        return new BasicAsyncEntityProducer(byArray, contentType);
    }

    public static AsyncEntityProducer create(File file, ContentType contentType) {
        return new FileEntityProducer(file, contentType);
    }

    public static AsyncEntityProducer createUrlEncoded(Iterable<? extends NameValuePair> iterable, Charset object) {
        object = object != null ? ContentType.APPLICATION_FORM_URLENCODED.withCharset((Charset)object) : ContentType.APPLICATION_FORM_URLENCODED;
        return AsyncEntityProducers.create(WWWFormCodec.format(iterable, ((ContentType)object).getCharset()), (ContentType)object);
    }

    public static AsyncEntityProducer createBinary(Callback<StreamChannel<ByteBuffer>> callback, ContentType contentType) {
        return new AsyncEntityProducers$1(0, contentType, callback);
    }

    public static AsyncEntityProducer createText(Callback<StreamChannel<CharBuffer>> callback, ContentType contentType) {
        return new AsyncEntityProducers$2(4096, 2048, contentType, callback);
    }

    public static AsyncEntityProducer withTrailers(AsyncEntityProducer asyncEntityProducer, Header ... headerArray) {
        return new AsyncEntityProducers$3(asyncEntityProducer, headerArray);
    }

    public static AsyncEntityProducer create(String string, ContentType contentType, Header ... headerArray) {
        return AsyncEntityProducers.withTrailers(AsyncEntityProducers.create(string, contentType), headerArray);
    }

    public static AsyncEntityProducer create(String string, Charset charset, Header ... headerArray) {
        return AsyncEntityProducers.withTrailers(AsyncEntityProducers.create(string, charset), headerArray);
    }

    public static AsyncEntityProducer create(String string, Header ... headerArray) {
        return AsyncEntityProducers.withTrailers(AsyncEntityProducers.create(string), headerArray);
    }

    public static AsyncEntityProducer create(byte[] byArray, ContentType contentType, Header ... headerArray) {
        return AsyncEntityProducers.withTrailers(AsyncEntityProducers.create(byArray, contentType), headerArray);
    }

    public static AsyncEntityProducer create(File file, ContentType contentType, Header ... headerArray) {
        return AsyncEntityProducers.withTrailers(AsyncEntityProducers.create(file, contentType), headerArray);
    }

    public static AsyncEntityProducer create(Path path, ContentType contentType, Header ... headerArray) throws IOException {
        return AsyncEntityProducers.withTrailers(new PathEntityProducer(path, contentType, StandardOpenOption.READ), headerArray);
    }

    public static AsyncEntityProducer create(Path path, ContentType contentType, OpenOption ... openOptionArray) throws IOException {
        return new PathEntityProducer(path, contentType, openOptionArray);
    }

    public static AsyncEntityProducer createBinary(Callback<StreamChannel<ByteBuffer>> callback, ContentType contentType, Header ... headerArray) {
        return AsyncEntityProducers.withTrailers(AsyncEntityProducers.createBinary(callback, contentType), headerArray);
    }

    public static AsyncEntityProducer createText(Callback<StreamChannel<CharBuffer>> callback, ContentType contentType, Header ... headerArray) {
        return AsyncEntityProducers.withTrailers(AsyncEntityProducers.createText(callback, contentType), headerArray);
    }
}

