/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.nio.entity;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.nio.AsyncEntityProducer;
import org.apache.hc.core5.http.nio.DataStreamChannel;
import org.apache.hc.core5.util.Args;

public class BasicAsyncEntityProducer
implements AsyncEntityProducer {
    private final ByteBuffer bytebuf;
    private final int length;
    private final ContentType contentType;
    private final boolean chunked;
    private final AtomicReference<Exception> exception;

    public BasicAsyncEntityProducer(byte[] byArray, ContentType contentType, boolean bl2) {
        Args.notNull(byArray, "Content");
        this.bytebuf = ByteBuffer.wrap(byArray);
        this.length = this.bytebuf.remaining();
        this.contentType = contentType;
        this.chunked = bl2;
        this.exception = new AtomicReference();
    }

    public BasicAsyncEntityProducer(byte[] byArray, ContentType contentType) {
        this(byArray, contentType, false);
    }

    public BasicAsyncEntityProducer(byte[] byArray) {
        this(byArray, ContentType.APPLICATION_OCTET_STREAM);
    }

    public BasicAsyncEntityProducer(CharSequence charSequence, ContentType object, boolean bl2) {
        Args.notNull(charSequence, "Content");
        this.contentType = object;
        object = ContentType.getCharset((ContentType)object, StandardCharsets.UTF_8);
        this.bytebuf = ((Charset)object).encode(CharBuffer.wrap(charSequence));
        this.length = this.bytebuf.remaining();
        this.chunked = bl2;
        this.exception = new AtomicReference();
    }

    public BasicAsyncEntityProducer(CharSequence charSequence, ContentType contentType) {
        this(charSequence, contentType, false);
    }

    public BasicAsyncEntityProducer(CharSequence charSequence) {
        this(charSequence, ContentType.TEXT_PLAIN);
    }

    @Override
    public boolean isRepeatable() {
        return true;
    }

    @Override
    public final String getContentType() {
        return Objects.toString(this.contentType, null);
    }

    @Override
    public long getContentLength() {
        return this.length;
    }

    @Override
    public int available() {
        return Integer.MAX_VALUE;
    }

    @Override
    public String getContentEncoding() {
        return null;
    }

    @Override
    public boolean isChunked() {
        return this.chunked;
    }

    @Override
    public Set<String> getTrailerNames() {
        return Collections.emptySet();
    }

    @Override
    public final void produce(DataStreamChannel dataStreamChannel) throws IOException {
        if (this.bytebuf.hasRemaining()) {
            dataStreamChannel.write(this.bytebuf);
        }
        if (!this.bytebuf.hasRemaining()) {
            dataStreamChannel.endStream();
        }
    }

    @Override
    public final void failed(Exception exception) {
        if (this.exception.compareAndSet(null, exception)) {
            this.releaseResources();
        }
    }

    public final Exception getException() {
        return this.exception.get();
    }

    @Override
    public void releaseResources() {
        this.bytebuf.clear();
        this.bytebuf.limit(this.length);
    }
}

