/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.nio.entity;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.nio.AsyncEntityProducer;
import org.apache.hc.core5.http.nio.DataStreamChannel;
import org.apache.hc.core5.io.Closer;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.Asserts;

public final class PathEntityProducer
implements AsyncEntityProducer {
    private static final int BUFFER_SIZE = 8192;
    private final Path file;
    private final OpenOption[] openOptions;
    private final ByteBuffer byteBuffer;
    private final long length;
    private final ContentType contentType;
    private final boolean chunked;
    private final AtomicReference<Exception> exception;
    private final AtomicReference<SeekableByteChannel> channelRef;
    private boolean eof;

    public PathEntityProducer(Path path, ContentType contentType, boolean bl2, OpenOption ... openOptionArray) throws IOException {
        this(path, 8192, contentType, bl2, openOptionArray);
    }

    public PathEntityProducer(Path path, ContentType contentType, OpenOption ... openOptionArray) throws IOException {
        this(path, contentType, false, openOptionArray);
    }

    public PathEntityProducer(Path path, int n2, ContentType contentType, boolean bl2, OpenOption ... openOptionArray) throws IOException {
        this.file = Args.notNull(path, "file");
        this.openOptions = openOptionArray;
        this.length = Files.size(path);
        this.byteBuffer = ByteBuffer.allocate(n2);
        this.contentType = contentType;
        this.chunked = bl2;
        this.channelRef = new AtomicReference();
        this.exception = new AtomicReference();
    }

    public PathEntityProducer(Path path, OpenOption ... openOptionArray) throws IOException {
        this(path, ContentType.APPLICATION_OCTET_STREAM, openOptionArray);
    }

    @Override
    public final int available() {
        return Integer.MAX_VALUE;
    }

    @Override
    public final void failed(Exception exception) {
        if (this.exception.compareAndSet(null, exception)) {
            this.releaseResources();
        }
    }

    @Override
    public final String getContentEncoding() {
        return null;
    }

    @Override
    public final long getContentLength() {
        return this.length;
    }

    @Override
    public final String getContentType() {
        return Objects.toString(this.contentType, null);
    }

    public final Exception getException() {
        return this.exception.get();
    }

    @Override
    public final Set<String> getTrailerNames() {
        return Collections.emptySet();
    }

    @Override
    public final boolean isChunked() {
        return this.chunked;
    }

    @Override
    public final boolean isRepeatable() {
        return true;
    }

    @Override
    public final void produce(DataStreamChannel dataStreamChannel) throws IOException {
        int n2;
        SeekableByteChannel seekableByteChannel = this.channelRef.get();
        if (seekableByteChannel == null) {
            seekableByteChannel = Files.newByteChannel(this.file, this.openOptions);
            Asserts.check(this.channelRef.getAndSet(seekableByteChannel) == null, "Illegal producer state");
        }
        if (!this.eof && (n2 = seekableByteChannel.read(this.byteBuffer)) < 0) {
            this.eof = true;
        }
        if (this.byteBuffer.position() > 0) {
            this.byteBuffer.flip();
            dataStreamChannel.write(this.byteBuffer);
            this.byteBuffer.compact();
        }
        if (this.eof && this.byteBuffer.position() == 0) {
            dataStreamChannel.endStream();
            this.releaseResources();
        }
    }

    @Override
    public final void releaseResources() {
        this.eof = false;
        Closer.closeQuietly(this.channelRef.getAndSet(null));
    }
}

