/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.nio.entity;

import java.io.IOException;
import java.nio.CharBuffer;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.nio.StreamChannel;
import org.apache.hc.core5.http.nio.entity.AbstractCharAsyncEntityProducer;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.Asserts;

public class StringAsyncEntityProducer
extends AbstractCharAsyncEntityProducer {
    private final CharBuffer content;
    private final AtomicReference<Exception> exception;

    public StringAsyncEntityProducer(CharSequence charSequence, int n2, int n3, ContentType contentType) {
        super(n2, n3, contentType);
        Args.notNull(charSequence, "Content");
        this.content = CharBuffer.wrap(charSequence);
        this.exception = new AtomicReference();
    }

    public StringAsyncEntityProducer(CharSequence charSequence, int n2, ContentType contentType) {
        this(charSequence, n2, -1, contentType);
    }

    public StringAsyncEntityProducer(CharSequence charSequence, ContentType contentType) {
        this(charSequence, 4096, contentType);
    }

    public StringAsyncEntityProducer(CharSequence charSequence) {
        this(charSequence, ContentType.TEXT_PLAIN);
    }

    @Override
    public boolean isRepeatable() {
        return true;
    }

    @Override
    protected int availableData() {
        return Integer.MAX_VALUE;
    }

    @Override
    protected void produceData(StreamChannel<CharBuffer> streamChannel) throws IOException {
        Asserts.notNull(streamChannel, "Channel");
        streamChannel.write(this.content);
        if (!this.content.hasRemaining()) {
            streamChannel.endStream();
        }
    }

    @Override
    public void failed(Exception exception) {
        if (this.exception.compareAndSet(null, exception)) {
            ((AbstractCharAsyncEntityProducer)this).releaseResources();
        }
    }

    public Exception getException() {
        return this.exception.get();
    }

    @Override
    public void releaseResources() {
        this.content.clear();
        super.releaseResources();
    }
}

