/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.nio.support;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.nio.AsyncRequestConsumer;
import org.apache.hc.core5.http.nio.AsyncResponseProducer;
import org.apache.hc.core5.http.nio.AsyncServerExchangeHandler;
import org.apache.hc.core5.http.nio.AsyncServerRequestHandler$ResponseTrigger;
import org.apache.hc.core5.http.nio.CapacityChannel;
import org.apache.hc.core5.http.nio.DataStreamChannel;
import org.apache.hc.core5.http.nio.ResourceHolder;
import org.apache.hc.core5.http.nio.ResponseChannel;
import org.apache.hc.core5.http.nio.support.AbstractServerExchangeHandler$1;
import org.apache.hc.core5.http.nio.support.AbstractServerExchangeHandler$2;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.Asserts;

public abstract class AbstractServerExchangeHandler<T>
implements AsyncServerExchangeHandler {
    private final AtomicReference<AsyncRequestConsumer<T>> requestConsumerRef = new AtomicReference();
    private final AtomicReference<AsyncResponseProducer> responseProducerRef = new AtomicReference();

    protected abstract AsyncRequestConsumer<T> supplyConsumer(HttpRequest var1, EntityDetails var2, HttpContext var3) throws HttpException;

    protected abstract void handle(T var1, AsyncServerRequestHandler$ResponseTrigger var2, HttpContext var3) throws HttpException, IOException;

    @Override
    public final void handleRequest(HttpRequest httpRequest, EntityDetails entityDetails, ResponseChannel object, HttpContext httpContext) throws HttpException, IOException {
        AsyncRequestConsumer<T> asyncRequestConsumer = this.supplyConsumer(httpRequest, entityDetails, httpContext);
        if (asyncRequestConsumer == null) {
            throw new HttpException("Unable to handle request");
        }
        this.requestConsumerRef.set(asyncRequestConsumer);
        object = new AbstractServerExchangeHandler$1(this, (ResponseChannel)object);
        asyncRequestConsumer.consumeRequest(httpRequest, entityDetails, httpContext, new AbstractServerExchangeHandler$2(this, (AsyncServerRequestHandler$ResponseTrigger)object, httpContext));
    }

    @Override
    public final void updateCapacity(CapacityChannel capacityChannel) throws IOException {
        AsyncRequestConsumer<T> asyncRequestConsumer = this.requestConsumerRef.get();
        Asserts.notNull(asyncRequestConsumer, "Data consumer");
        asyncRequestConsumer.updateCapacity(capacityChannel);
    }

    @Override
    public final void consume(ByteBuffer byteBuffer) throws IOException {
        AsyncRequestConsumer<T> asyncRequestConsumer = this.requestConsumerRef.get();
        Asserts.notNull(asyncRequestConsumer, "Data consumer");
        asyncRequestConsumer.consume(byteBuffer);
    }

    @Override
    public final void streamEnd(List<? extends Header> list) throws HttpException, IOException {
        AsyncRequestConsumer<T> asyncRequestConsumer = this.requestConsumerRef.get();
        Asserts.notNull(asyncRequestConsumer, "Data consumer");
        asyncRequestConsumer.streamEnd(list);
    }

    @Override
    public final int available() {
        AsyncResponseProducer asyncResponseProducer = this.responseProducerRef.get();
        if (asyncResponseProducer != null) {
            return asyncResponseProducer.available();
        }
        return 0;
    }

    @Override
    public final void produce(DataStreamChannel dataStreamChannel) throws IOException {
        AsyncResponseProducer asyncResponseProducer = this.responseProducerRef.get();
        Asserts.notNull(asyncResponseProducer, "Data producer");
        asyncResponseProducer.produce(dataStreamChannel);
    }

    @Override
    public final void failed(Exception exception) {
        this.failedInternal(exception);
    }

    void failedInternal(Exception exception) {
        ResourceHolder resourceHolder;
        try {
            resourceHolder = this.requestConsumerRef.get();
            if (resourceHolder != null) {
                resourceHolder.failed(exception);
            }
        }
        finally {
            this.releaseRequestConsumer();
        }
        try {
            resourceHolder = this.responseProducerRef.get();
            if (resourceHolder != null) {
                resourceHolder.failed(exception);
            }
            return;
        }
        finally {
            this.releaseResponseProducer();
        }
    }

    private void releaseRequestConsumer() {
        AsyncRequestConsumer asyncRequestConsumer = this.requestConsumerRef.getAndSet(null);
        if (asyncRequestConsumer != null) {
            asyncRequestConsumer.releaseResources();
        }
    }

    private void releaseResponseProducer() {
        AsyncResponseProducer asyncResponseProducer = this.responseProducerRef.getAndSet(null);
        if (asyncResponseProducer != null) {
            asyncResponseProducer.releaseResources();
        }
    }

    private void releaseResourcesInternal() {
        this.releaseResponseProducer();
        this.releaseRequestConsumer();
    }

    @Override
    public final void releaseResources() {
        this.releaseResponseProducer();
    }

    static /* synthetic */ AtomicReference access$000(AbstractServerExchangeHandler abstractServerExchangeHandler) {
        return abstractServerExchangeHandler.responseProducerRef;
    }

    static /* synthetic */ void access$100(AbstractServerExchangeHandler abstractServerExchangeHandler) {
        abstractServerExchangeHandler.releaseRequestConsumer();
    }

    static /* synthetic */ void access$200(AbstractServerExchangeHandler abstractServerExchangeHandler) {
        abstractServerExchangeHandler.releaseResourcesInternal();
    }
}

