/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.nio.support;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.Method;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.message.BasicHttpRequest;
import org.apache.hc.core5.http.message.HeaderGroup;
import org.apache.hc.core5.http.nio.AsyncEntityProducer;
import org.apache.hc.core5.http.nio.AsyncRequestProducer;
import org.apache.hc.core5.http.nio.entity.BasicAsyncEntityProducer;
import org.apache.hc.core5.http.nio.entity.StringAsyncEntityProducer;
import org.apache.hc.core5.http.nio.support.BasicRequestProducer;
import org.apache.hc.core5.http.support.AbstractRequestBuilder;
import org.apache.hc.core5.net.URIAuthority;
import org.apache.hc.core5.net.URIBuilder;
import org.apache.hc.core5.net.WWWFormCodec;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.TextUtils;

public class AsyncRequestBuilder
extends AbstractRequestBuilder<AsyncRequestProducer> {
    private AsyncEntityProducer entityProducer;

    AsyncRequestBuilder(String string) {
        super(string);
    }

    AsyncRequestBuilder(Method method) {
        super(method);
    }

    AsyncRequestBuilder(String string, URI uRI) {
        super(string, uRI);
    }

    AsyncRequestBuilder(Method method, URI uRI) {
        this(method.name(), uRI);
    }

    AsyncRequestBuilder(Method method, String string) {
        this(method.name(), string != null ? URI.create(string) : null);
    }

    AsyncRequestBuilder(String string, String string2) {
        this(string, string2 != null ? URI.create(string2) : null);
    }

    public static AsyncRequestBuilder create(String string) {
        Args.notBlank(string, "HTTP method");
        return new AsyncRequestBuilder(string);
    }

    public static AsyncRequestBuilder get() {
        return new AsyncRequestBuilder(Method.GET);
    }

    public static AsyncRequestBuilder get(URI uRI) {
        return new AsyncRequestBuilder(Method.GET, uRI);
    }

    public static AsyncRequestBuilder get(String string) {
        return new AsyncRequestBuilder(Method.GET, string);
    }

    public static AsyncRequestBuilder head() {
        return new AsyncRequestBuilder(Method.HEAD);
    }

    public static AsyncRequestBuilder head(URI uRI) {
        return new AsyncRequestBuilder(Method.HEAD, uRI);
    }

    public static AsyncRequestBuilder head(String string) {
        return new AsyncRequestBuilder(Method.HEAD, string);
    }

    public static AsyncRequestBuilder patch() {
        return new AsyncRequestBuilder(Method.PATCH);
    }

    public static AsyncRequestBuilder patch(URI uRI) {
        return new AsyncRequestBuilder(Method.PATCH, uRI);
    }

    public static AsyncRequestBuilder patch(String string) {
        return new AsyncRequestBuilder(Method.PATCH, string);
    }

    public static AsyncRequestBuilder post() {
        return new AsyncRequestBuilder(Method.POST);
    }

    public static AsyncRequestBuilder post(URI uRI) {
        return new AsyncRequestBuilder(Method.POST, uRI);
    }

    public static AsyncRequestBuilder post(String string) {
        return new AsyncRequestBuilder(Method.POST, string);
    }

    public static AsyncRequestBuilder put() {
        return new AsyncRequestBuilder(Method.PUT);
    }

    public static AsyncRequestBuilder put(URI uRI) {
        return new AsyncRequestBuilder(Method.PUT, uRI);
    }

    public static AsyncRequestBuilder put(String string) {
        return new AsyncRequestBuilder(Method.PUT, string);
    }

    public static AsyncRequestBuilder delete() {
        return new AsyncRequestBuilder(Method.DELETE);
    }

    public static AsyncRequestBuilder delete(URI uRI) {
        return new AsyncRequestBuilder(Method.DELETE, uRI);
    }

    public static AsyncRequestBuilder delete(String string) {
        return new AsyncRequestBuilder(Method.DELETE, string);
    }

    public static AsyncRequestBuilder trace() {
        return new AsyncRequestBuilder(Method.TRACE);
    }

    public static AsyncRequestBuilder trace(URI uRI) {
        return new AsyncRequestBuilder(Method.TRACE, uRI);
    }

    public static AsyncRequestBuilder trace(String string) {
        return new AsyncRequestBuilder(Method.TRACE, string);
    }

    public static AsyncRequestBuilder options() {
        return new AsyncRequestBuilder(Method.OPTIONS);
    }

    public static AsyncRequestBuilder options(URI uRI) {
        return new AsyncRequestBuilder(Method.OPTIONS, uRI);
    }

    public static AsyncRequestBuilder options(String string) {
        return new AsyncRequestBuilder(Method.OPTIONS, string);
    }

    @Override
    public AsyncRequestBuilder setVersion(ProtocolVersion protocolVersion) {
        super.setVersion(protocolVersion);
        return this;
    }

    public AsyncRequestBuilder setUri(URI uRI) {
        super.setUri(uRI);
        return this;
    }

    public AsyncRequestBuilder setUri(String string) {
        super.setUri(string);
        return this;
    }

    public AsyncRequestBuilder setScheme(String string) {
        super.setScheme(string);
        return this;
    }

    public AsyncRequestBuilder setAuthority(URIAuthority uRIAuthority) {
        super.setAuthority(uRIAuthority);
        return this;
    }

    public AsyncRequestBuilder setHttpHost(HttpHost httpHost) {
        super.setHttpHost(httpHost);
        return this;
    }

    public AsyncRequestBuilder setPath(String string) {
        super.setPath(string);
        return this;
    }

    @Override
    public AsyncRequestBuilder setHeaders(Header ... headerArray) {
        super.setHeaders(headerArray);
        return this;
    }

    @Override
    public AsyncRequestBuilder addHeader(Header header) {
        super.addHeader(header);
        return this;
    }

    @Override
    public AsyncRequestBuilder addHeader(String string, String string2) {
        super.addHeader(string, string2);
        return this;
    }

    @Override
    public AsyncRequestBuilder removeHeader(Header header) {
        super.removeHeader(header);
        return this;
    }

    @Override
    public AsyncRequestBuilder removeHeaders(String string) {
        super.removeHeaders(string);
        return this;
    }

    @Override
    public AsyncRequestBuilder setHeader(Header header) {
        super.setHeader(header);
        return this;
    }

    @Override
    public AsyncRequestBuilder setHeader(String string, String string2) {
        super.setHeader(string, string2);
        return this;
    }

    public AsyncRequestBuilder setCharset(Charset charset) {
        super.setCharset(charset);
        return this;
    }

    public AsyncRequestBuilder addParameter(NameValuePair nameValuePair) {
        super.addParameter(nameValuePair);
        return this;
    }

    public AsyncRequestBuilder addParameter(String string, String string2) {
        super.addParameter(string, string2);
        return this;
    }

    public AsyncRequestBuilder addParameters(NameValuePair ... nameValuePairArray) {
        super.addParameters(nameValuePairArray);
        return this;
    }

    public AsyncRequestBuilder setAbsoluteRequestUri(boolean bl2) {
        super.setAbsoluteRequestUri(bl2);
        return this;
    }

    public AsyncEntityProducer getEntity() {
        return this.entityProducer;
    }

    public AsyncRequestBuilder setEntity(AsyncEntityProducer asyncEntityProducer) {
        this.entityProducer = asyncEntityProducer;
        return this;
    }

    public AsyncRequestBuilder setEntity(String string, ContentType contentType) {
        this.entityProducer = new BasicAsyncEntityProducer(string, contentType);
        return this;
    }

    public AsyncRequestBuilder setEntity(String string) {
        this.entityProducer = new BasicAsyncEntityProducer(string);
        return this;
    }

    public AsyncRequestBuilder setEntity(byte[] byArray, ContentType contentType) {
        this.entityProducer = new BasicAsyncEntityProducer(byArray, contentType);
        return this;
    }

    @Override
    public AsyncRequestProducer build() {
        Object object;
        String string = this.getPath();
        if (TextUtils.isEmpty(string)) {
            string = "/";
        }
        AsyncEntityProducer asyncEntityProducer = this.entityProducer;
        String string2 = this.getMethod();
        List<NameValuePair> list = this.getParameters();
        if (list != null && !list.isEmpty()) {
            object = this.getCharset();
            if (asyncEntityProducer == null && (Method.POST.isSame(string2) || Method.PUT.isSame(string2))) {
                list = WWWFormCodec.format(list, (Charset)(object != null ? object : ContentType.APPLICATION_FORM_URLENCODED.getCharset()));
                asyncEntityProducer = new StringAsyncEntityProducer((CharSequence)((Object)list), ContentType.APPLICATION_FORM_URLENCODED);
            } else {
                try {
                    list = new URIBuilder(string).setCharset((Charset)object).addParameters(list).build();
                    string = ((URI)((Object)list)).toASCIIString();
                }
                catch (URISyntaxException uRISyntaxException) {}
            }
        }
        if (asyncEntityProducer != null && Method.TRACE.isSame(string2)) {
            throw new IllegalStateException((Object)((Object)Method.TRACE) + " requests may not include an entity");
        }
        object = new BasicHttpRequest(string2, this.getScheme(), this.getAuthority(), string);
        ((BasicHttpRequest)object).setVersion(this.getVersion());
        ((HeaderGroup)object).setHeaders(this.getHeaders());
        ((BasicHttpRequest)object).setAbsoluteRequestUri(this.isAbsoluteRequestUri());
        return new BasicRequestProducer((HttpRequest)object, asyncEntityProducer);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("AsyncRequestBuilder [method=");
        stringBuilder.append(this.getMethod());
        stringBuilder.append(", scheme=");
        stringBuilder.append(this.getScheme());
        stringBuilder.append(", authority=");
        stringBuilder.append(this.getAuthority());
        stringBuilder.append(", path=");
        stringBuilder.append(this.getPath());
        stringBuilder.append(", parameters=");
        stringBuilder.append(this.getParameters());
        stringBuilder.append(", headerGroup=");
        stringBuilder.append(Arrays.toString(this.getHeaders()));
        stringBuilder.append(", entity=");
        stringBuilder.append(this.entityProducer != null ? this.entityProducer.getClass() : null);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

