/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.nio.support;

import java.util.Arrays;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.message.BasicHttpResponse;
import org.apache.hc.core5.http.nio.AsyncEntityProducer;
import org.apache.hc.core5.http.nio.AsyncResponseProducer;
import org.apache.hc.core5.http.nio.entity.BasicAsyncEntityProducer;
import org.apache.hc.core5.http.nio.support.BasicResponseProducer;
import org.apache.hc.core5.http.support.AbstractResponseBuilder;
import org.apache.hc.core5.util.Args;

public class AsyncResponseBuilder
extends AbstractResponseBuilder<AsyncResponseProducer> {
    private AsyncEntityProducer entityProducer;

    AsyncResponseBuilder(int n2) {
        super(n2);
    }

    public static AsyncResponseBuilder create(int n2) {
        Args.checkRange(n2, 100, 599, "HTTP status code");
        return new AsyncResponseBuilder(n2);
    }

    @Override
    public AsyncResponseBuilder setVersion(ProtocolVersion protocolVersion) {
        super.setVersion(protocolVersion);
        return this;
    }

    @Override
    public AsyncResponseBuilder setHeaders(Header ... headerArray) {
        super.setHeaders(headerArray);
        return this;
    }

    @Override
    public AsyncResponseBuilder addHeader(Header header) {
        super.addHeader(header);
        return this;
    }

    @Override
    public AsyncResponseBuilder addHeader(String string, String string2) {
        super.addHeader(string, string2);
        return this;
    }

    @Override
    public AsyncResponseBuilder removeHeader(Header header) {
        super.removeHeader(header);
        return this;
    }

    @Override
    public AsyncResponseBuilder removeHeaders(String string) {
        super.removeHeaders(string);
        return this;
    }

    @Override
    public AsyncResponseBuilder setHeader(Header header) {
        super.setHeader(header);
        return this;
    }

    @Override
    public AsyncResponseBuilder setHeader(String string, String string2) {
        super.setHeader(string, string2);
        return this;
    }

    public AsyncEntityProducer getEntity() {
        return this.entityProducer;
    }

    public AsyncResponseBuilder setEntity(AsyncEntityProducer asyncEntityProducer) {
        this.entityProducer = asyncEntityProducer;
        return this;
    }

    public AsyncResponseBuilder setEntity(String string, ContentType contentType) {
        this.entityProducer = new BasicAsyncEntityProducer(string, contentType);
        return this;
    }

    public AsyncResponseBuilder setEntity(String string) {
        this.entityProducer = new BasicAsyncEntityProducer(string);
        return this;
    }

    public AsyncResponseBuilder setEntity(byte[] byArray, ContentType contentType) {
        this.entityProducer = new BasicAsyncEntityProducer(byArray, contentType);
        return this;
    }

    @Override
    public AsyncResponseProducer build() {
        BasicHttpResponse basicHttpResponse = new BasicHttpResponse(this.getStatus());
        basicHttpResponse.setVersion(this.getVersion());
        basicHttpResponse.setHeaders(this.getHeaders());
        return new BasicResponseProducer((HttpResponse)basicHttpResponse, this.entityProducer);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("AsyncResponseBuilder [status=");
        stringBuilder.append(this.getStatus());
        stringBuilder.append(", headerGroup=");
        stringBuilder.append(Arrays.toString(this.getHeaders()));
        stringBuilder.append(", entity=");
        stringBuilder.append(this.entityProducer != null ? this.entityProducer.getClass() : null);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

