/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.nio.support;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.nio.AsyncDataConsumer;
import org.apache.hc.core5.http.nio.AsyncResponseProducer;
import org.apache.hc.core5.http.nio.AsyncServerExchangeHandler;
import org.apache.hc.core5.http.nio.CapacityChannel;
import org.apache.hc.core5.http.nio.DataStreamChannel;
import org.apache.hc.core5.http.nio.ResourceHolder;
import org.apache.hc.core5.http.nio.ResponseChannel;
import org.apache.hc.core5.http.nio.support.AsyncServerFilterChainExchangeHandlerFactory;
import org.apache.hc.core5.http.nio.support.AsyncServerFilterChainExchangeHandlerFactory$1$1;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.Asserts;

class AsyncServerFilterChainExchangeHandlerFactory$1
implements AsyncServerExchangeHandler {
    private final AtomicReference<AsyncDataConsumer> dataConsumerRef = new AtomicReference();
    private final AtomicReference<AsyncResponseProducer> responseProducerRef = new AtomicReference();
    final /* synthetic */ AsyncServerFilterChainExchangeHandlerFactory this$0;

    AsyncServerFilterChainExchangeHandlerFactory$1(AsyncServerFilterChainExchangeHandlerFactory asyncServerFilterChainExchangeHandlerFactory) {
        this.this$0 = asyncServerFilterChainExchangeHandlerFactory;
    }

    @Override
    public void handleRequest(HttpRequest httpRequest, EntityDetails entityDetails, ResponseChannel responseChannel, HttpContext httpContext) throws HttpException, IOException {
        this.dataConsumerRef.set(AsyncServerFilterChainExchangeHandlerFactory.access$100(this.this$0).handle(httpRequest, entityDetails, httpContext, new AsyncServerFilterChainExchangeHandlerFactory$1$1(this, responseChannel, httpContext)));
    }

    @Override
    public void failed(Exception exception) {
        AsyncResponseProducer asyncResponseProducer;
        if (AsyncServerFilterChainExchangeHandlerFactory.access$200(this.this$0) != null) {
            AsyncServerFilterChainExchangeHandlerFactory.access$200(this.this$0).execute(exception);
        }
        if ((asyncResponseProducer = this.responseProducerRef.get()) != null) {
            asyncResponseProducer.failed(exception);
        }
    }

    @Override
    public void updateCapacity(CapacityChannel capacityChannel) throws IOException {
        AsyncDataConsumer asyncDataConsumer = this.dataConsumerRef.get();
        if (asyncDataConsumer != null) {
            asyncDataConsumer.updateCapacity(capacityChannel);
            return;
        }
        capacityChannel.update(Integer.MAX_VALUE);
    }

    @Override
    public void consume(ByteBuffer byteBuffer) throws IOException {
        AsyncDataConsumer asyncDataConsumer = this.dataConsumerRef.get();
        if (asyncDataConsumer != null) {
            asyncDataConsumer.consume(byteBuffer);
        }
    }

    @Override
    public void streamEnd(List<? extends Header> list) throws HttpException, IOException {
        AsyncDataConsumer asyncDataConsumer = this.dataConsumerRef.get();
        if (asyncDataConsumer != null) {
            asyncDataConsumer.streamEnd(list);
        }
    }

    @Override
    public int available() {
        AsyncResponseProducer asyncResponseProducer = this.responseProducerRef.get();
        Asserts.notNull(asyncResponseProducer, "Response producer");
        return asyncResponseProducer.available();
    }

    @Override
    public void produce(DataStreamChannel dataStreamChannel) throws IOException {
        AsyncResponseProducer asyncResponseProducer = this.responseProducerRef.get();
        Asserts.notNull(asyncResponseProducer, "Response producer");
        asyncResponseProducer.produce(dataStreamChannel);
    }

    @Override
    public void releaseResources() {
        ResourceHolder resourceHolder = this.dataConsumerRef.getAndSet(null);
        if (resourceHolder != null) {
            resourceHolder.releaseResources();
        }
        if ((resourceHolder = (AsyncResponseProducer)this.responseProducerRef.getAndSet(null)) != null) {
            resourceHolder.releaseResources();
        }
    }

    static /* synthetic */ AtomicReference access$000(AsyncServerFilterChainExchangeHandlerFactory$1 asyncServerFilterChainExchangeHandlerFactory$1) {
        return asyncServerFilterChainExchangeHandlerFactory$1.responseProducerRef;
    }
}

