/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.nio.support;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hc.core5.function.Callback;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.message.BasicHttpResponse;
import org.apache.hc.core5.http.nio.AsyncResponseProducer;
import org.apache.hc.core5.http.nio.AsyncServerExchangeHandler;
import org.apache.hc.core5.http.nio.CapacityChannel;
import org.apache.hc.core5.http.nio.DataStreamChannel;
import org.apache.hc.core5.http.nio.ResponseChannel;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.Args;

public class BasicAsyncServerExpectationDecorator
implements AsyncServerExchangeHandler {
    private final AsyncServerExchangeHandler handler;
    private final Callback<Exception> exceptionCallback;
    private final AtomicReference<AsyncResponseProducer> responseProducerRef;

    public BasicAsyncServerExpectationDecorator(AsyncServerExchangeHandler asyncServerExchangeHandler, Callback<Exception> callback) {
        this.handler = Args.notNull(asyncServerExchangeHandler, "Handler");
        this.exceptionCallback = callback;
        this.responseProducerRef = new AtomicReference();
    }

    public BasicAsyncServerExpectationDecorator(AsyncServerExchangeHandler asyncServerExchangeHandler) {
        this(asyncServerExchangeHandler, null);
    }

    protected AsyncResponseProducer verify(HttpRequest httpRequest, HttpContext httpContext) throws IOException, HttpException {
        return null;
    }

    @Override
    public final void handleRequest(HttpRequest httpRequest, EntityDetails entityDetails, ResponseChannel responseChannel, HttpContext httpContext) throws HttpException, IOException {
        Object object;
        if (entityDetails != null && (object = httpRequest.getFirstHeader("Expect")) != null && "100-continue".equalsIgnoreCase(object.getValue())) {
            object = this.verify(httpRequest, httpContext);
            if (object != null) {
                this.responseProducerRef.set((AsyncResponseProducer)object);
                object.sendResponse(responseChannel, httpContext);
                return;
            }
            responseChannel.sendInformation(new BasicHttpResponse(100), httpContext);
        }
        this.handler.handleRequest(httpRequest, entityDetails, responseChannel, httpContext);
    }

    @Override
    public final void updateCapacity(CapacityChannel capacityChannel) throws IOException {
        AsyncResponseProducer asyncResponseProducer = this.responseProducerRef.get();
        if (asyncResponseProducer == null) {
            this.handler.updateCapacity(capacityChannel);
            return;
        }
        capacityChannel.update(Integer.MAX_VALUE);
    }

    @Override
    public final void consume(ByteBuffer byteBuffer) throws IOException {
        AsyncResponseProducer asyncResponseProducer = this.responseProducerRef.get();
        if (asyncResponseProducer == null) {
            this.handler.consume(byteBuffer);
        }
    }

    @Override
    public final void streamEnd(List<? extends Header> list) throws HttpException, IOException {
        AsyncResponseProducer asyncResponseProducer = this.responseProducerRef.get();
        if (asyncResponseProducer == null) {
            this.handler.streamEnd(list);
        }
    }

    @Override
    public final int available() {
        AsyncResponseProducer asyncResponseProducer = this.responseProducerRef.get();
        if (asyncResponseProducer == null) {
            return this.handler.available();
        }
        return asyncResponseProducer.available();
    }

    @Override
    public final void produce(DataStreamChannel dataStreamChannel) throws IOException {
        AsyncResponseProducer asyncResponseProducer = this.responseProducerRef.get();
        if (asyncResponseProducer == null) {
            this.handler.produce(dataStreamChannel);
            return;
        }
        asyncResponseProducer.produce(dataStreamChannel);
    }

    @Override
    public final void failed(Exception exception) {
        AsyncResponseProducer asyncResponseProducer;
        if (this.exceptionCallback != null) {
            this.exceptionCallback.execute(exception);
        }
        if ((asyncResponseProducer = this.responseProducerRef.get()) == null) {
            this.handler.failed(exception);
            return;
        }
        asyncResponseProducer.failed(exception);
    }

    @Override
    public final void releaseResources() {
        this.handler.releaseResources();
        AsyncResponseProducer asyncResponseProducer = this.responseProducerRef.getAndSet(null);
        if (asyncResponseProducer != null) {
            asyncResponseProducer.releaseResources();
        }
    }
}

