/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.nio.support;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.nio.AsyncClientExchangeHandler;
import org.apache.hc.core5.http.nio.AsyncRequestProducer;
import org.apache.hc.core5.http.nio.AsyncResponseConsumer;
import org.apache.hc.core5.http.nio.CapacityChannel;
import org.apache.hc.core5.http.nio.DataStreamChannel;
import org.apache.hc.core5.http.nio.RequestChannel;
import org.apache.hc.core5.http.nio.support.BasicClientExchangeHandler$1;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.Args;

public final class BasicClientExchangeHandler<T>
implements AsyncClientExchangeHandler {
    private final AsyncRequestProducer requestProducer;
    private final AsyncResponseConsumer<T> responseConsumer;
    private final AtomicBoolean completed;
    private final AtomicBoolean outputTerminated;
    private final AtomicBoolean inputTerminated;
    private final FutureCallback<T> resultCallback;

    public BasicClientExchangeHandler(AsyncRequestProducer asyncRequestProducer, AsyncResponseConsumer<T> asyncResponseConsumer, FutureCallback<T> futureCallback) {
        this.requestProducer = Args.notNull(asyncRequestProducer, "Request producer");
        this.responseConsumer = Args.notNull(asyncResponseConsumer, "Response consumer");
        this.completed = new AtomicBoolean();
        this.resultCallback = futureCallback;
        this.outputTerminated = new AtomicBoolean();
        this.inputTerminated = new AtomicBoolean();
    }

    @Override
    public final void produceRequest(RequestChannel requestChannel, HttpContext httpContext) throws HttpException, IOException {
        this.requestProducer.sendRequest(requestChannel, httpContext);
    }

    @Override
    public final int available() {
        return this.requestProducer.available();
    }

    @Override
    public final void produce(DataStreamChannel dataStreamChannel) throws IOException {
        if (this.outputTerminated.get()) {
            dataStreamChannel.endStream();
            return;
        }
        this.requestProducer.produce(dataStreamChannel);
    }

    @Override
    public final void consumeInformation(HttpResponse httpResponse, HttpContext httpContext) throws HttpException, IOException {
        this.responseConsumer.informationResponse(httpResponse, httpContext);
    }

    @Override
    public final void consumeResponse(HttpResponse httpResponse, EntityDetails entityDetails, HttpContext httpContext) throws HttpException, IOException {
        if (httpResponse.getCode() >= 400) {
            this.releaseRequestProducer();
        }
        this.responseConsumer.consumeResponse(httpResponse, entityDetails, httpContext, new BasicClientExchangeHandler$1(this));
    }

    @Override
    public final void cancel() {
        this.cancelledInternal();
    }

    @Override
    public final void updateCapacity(CapacityChannel capacityChannel) throws IOException {
        this.responseConsumer.updateCapacity(capacityChannel);
    }

    @Override
    public final void consume(ByteBuffer byteBuffer) throws IOException {
        this.responseConsumer.consume(byteBuffer);
    }

    @Override
    public final void streamEnd(List<? extends Header> list) throws HttpException, IOException {
        this.responseConsumer.streamEnd(list);
    }

    @Override
    public final void failed(Exception exception) {
        try {
            if (this.inputTerminated.get()) {
                this.responseConsumer.failed(exception);
            }
            if (!this.outputTerminated.get()) {
                this.requestProducer.failed(exception);
            }
            return;
        }
        finally {
            this.failedInternal(exception);
        }
    }

    private void completedInternal(T t2) {
        if (this.completed.compareAndSet(false, true)) {
            try {
                if (this.resultCallback != null) {
                    this.resultCallback.completed(t2);
                }
                return;
            }
            finally {
                this.releaseResourcesInternal();
            }
        }
    }

    private void failedInternal(Exception exception) {
        if (this.completed.compareAndSet(false, true)) {
            try {
                if (this.resultCallback != null) {
                    this.resultCallback.failed(exception);
                }
                return;
            }
            finally {
                this.releaseResourcesInternal();
            }
        }
    }

    private void cancelledInternal() {
        if (this.completed.compareAndSet(false, true)) {
            try {
                if (this.resultCallback != null) {
                    this.resultCallback.cancelled();
                }
                return;
            }
            finally {
                this.releaseResourcesInternal();
            }
        }
    }

    private void releaseResponseConsumer() {
        if (this.inputTerminated.compareAndSet(false, true)) {
            this.responseConsumer.releaseResources();
        }
    }

    private void releaseRequestProducer() {
        if (this.outputTerminated.compareAndSet(false, true)) {
            this.requestProducer.releaseResources();
        }
    }

    private void releaseResourcesInternal() {
        this.releaseRequestProducer();
        this.releaseResponseConsumer();
    }

    @Override
    public final void releaseResources() {
        this.releaseRequestProducer();
    }

    static /* synthetic */ void access$000(BasicClientExchangeHandler basicClientExchangeHandler, Object object) {
        basicClientExchangeHandler.completedInternal(object);
    }

    static /* synthetic */ void access$100(BasicClientExchangeHandler basicClientExchangeHandler, Exception exception) {
        basicClientExchangeHandler.failedInternal(exception);
    }

    static /* synthetic */ void access$200(BasicClientExchangeHandler basicClientExchangeHandler) {
        basicClientExchangeHandler.cancelledInternal();
    }
}

