/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.nio.support;

import java.io.IOException;
import java.net.URI;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.Method;
import org.apache.hc.core5.http.message.BasicHttpRequest;
import org.apache.hc.core5.http.nio.AsyncEntityProducer;
import org.apache.hc.core5.http.nio.AsyncRequestProducer;
import org.apache.hc.core5.http.nio.DataStreamChannel;
import org.apache.hc.core5.http.nio.RequestChannel;
import org.apache.hc.core5.http.protocol.HttpContext;

public class BasicRequestProducer
implements AsyncRequestProducer {
    private final HttpRequest request;
    private final AsyncEntityProducer dataProducer;

    public BasicRequestProducer(HttpRequest httpRequest, AsyncEntityProducer asyncEntityProducer) {
        this.request = httpRequest;
        this.dataProducer = asyncEntityProducer;
    }

    public BasicRequestProducer(String string, HttpHost httpHost, String string2, AsyncEntityProducer asyncEntityProducer) {
        this(new BasicHttpRequest(string, httpHost, string2), asyncEntityProducer);
    }

    public BasicRequestProducer(String string, HttpHost httpHost, String string2) {
        this(string, httpHost, string2, null);
    }

    public BasicRequestProducer(String string, URI uRI, AsyncEntityProducer asyncEntityProducer) {
        this(new BasicHttpRequest(string, uRI), asyncEntityProducer);
    }

    public BasicRequestProducer(String string, URI uRI) {
        this(string, uRI, null);
    }

    public BasicRequestProducer(Method method, HttpHost httpHost, String string, AsyncEntityProducer asyncEntityProducer) {
        this(new BasicHttpRequest(method, httpHost, string), asyncEntityProducer);
    }

    public BasicRequestProducer(Method method, HttpHost httpHost, String string) {
        this(method, httpHost, string, null);
    }

    public BasicRequestProducer(Method method, URI uRI, AsyncEntityProducer asyncEntityProducer) {
        this(new BasicHttpRequest(method, uRI), asyncEntityProducer);
    }

    public BasicRequestProducer(Method method, URI uRI) {
        this(method, uRI, null);
    }

    @Override
    public void sendRequest(RequestChannel requestChannel, HttpContext httpContext) throws HttpException, IOException {
        requestChannel.sendRequest(this.request, this.dataProducer, httpContext);
    }

    @Override
    public int available() {
        if (this.dataProducer != null) {
            return this.dataProducer.available();
        }
        return 0;
    }

    @Override
    public void produce(DataStreamChannel dataStreamChannel) throws IOException {
        if (this.dataProducer != null) {
            this.dataProducer.produce(dataStreamChannel);
        }
    }

    @Override
    public boolean isRepeatable() {
        return this.dataProducer == null || this.dataProducer.isRepeatable();
    }

    @Override
    public void failed(Exception exception) {
        try {
            if (this.dataProducer != null) {
                this.dataProducer.failed(exception);
            }
            return;
        }
        finally {
            this.releaseResources();
        }
    }

    @Override
    public void releaseResources() {
        if (this.dataProducer != null) {
            this.dataProducer.releaseResources();
        }
    }
}

